/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class Convert {
    private static String defaultEncoding = new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding();

    public static String fromUTF8(byte[] b) {
        String result;
        try {
            result = new String(b, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            result = new String(b);
        }
        return result;
    }

    public static byte[] toUTF8(String s) {
        byte[] result;
        try {
            result = s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            result = s.getBytes();
        }
        return result;
    }

    public static byte[] longToBytes(long value) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[bytes.length - 1 - i] = (byte)value;
            value >>>= 8;
        }
        return bytes;
    }

    public static long bytesToLong(byte[] value) {
        long longValue = 0L;
        for (int i = 0; i < value.length; ++i) {
            longValue <<= 8;
            longValue ^= (long)(value[i] & 0xFF);
        }
        return longValue;
    }

    public static byte[] toPlatformBytes(String target) {
        if (defaultEncoding == null) {
            return target.getBytes();
        }
        try {
            return target.getBytes(defaultEncoding);
        }
        catch (UnsupportedEncodingException e) {
            defaultEncoding = null;
            return target.getBytes();
        }
    }
}

