/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Header;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TypedListener;

public class TableColumn
extends Item {
    static final int FIRST = 0;
    static final int FILL = -1;
    private Table parent;
    private int index;
    private Rectangle bounds = new Rectangle(0, 0, 0, 0);
    private boolean isDefaultWidth = true;
    private boolean resize = true;

    TableColumn(Table parent) {
        super(parent, 0);
        this.parent = parent;
    }

    public TableColumn(Table parent, int style) {
        this(parent, style, TableColumn.checkNull(parent).getColumnCount());
    }

    public TableColumn(Table parent, int style, int index) {
        super(parent, TableColumn.checkStyle(style), index);
        this.parent = parent;
        if (index < 0 || index > parent.getColumnCount()) {
            this.error(6);
        }
        this.setIndex(index);
        parent.addColumn(this);
        this.setDefaultWidth(true);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                TableColumn.this.disposeColumn();
            }
        });
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static Table checkNull(Table table) {
        if (table == null) {
            SWT.error(4);
        }
        return table;
    }

    static int checkStyle(int style) {
        return TableColumn.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static TableColumn createDefaultColumn(Table parent) {
        TableColumn defaultColumn = new TableColumn(parent);
        defaultColumn.setIndex(0);
        defaultColumn.setDefaultWidth(true);
        return defaultColumn;
    }

    static TableColumn createFillColumn(Table parent) {
        TableColumn fillColumn = new TableColumn(parent);
        fillColumn.setIndex(-1);
        return fillColumn;
    }

    void disposeColumn() {
        this.getParent().removeColumn(this);
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    Rectangle getBounds() {
        return new Rectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    int getIndex() {
        return this.index;
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resize;
    }

    public int getWidth() {
        this.checkWidget();
        return this.getBounds().width;
    }

    void internalSetBounds(Rectangle newBounds) {
        this.bounds = newBounds;
    }

    boolean isDefaultWidth() {
        return this.isDefaultWidth;
    }

    public void pack() {
        this.checkWidget();
        Table parent = this.getParent();
        int index = parent.indexOf(this);
        if (this.getIndex() != -1 && index != -1) {
            this.setWidth(parent.getPreferredColumnWidth(index));
        }
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        int index = this.getIndex();
        if ((alignment & 0x1024000) != 0 && index != 0) {
            this.style &= 0xFEFDBFFF;
            this.style |= alignment & 0x1024000;
            this.getParent().getHeader().redraw(index);
        }
    }

    void setBounds(Rectangle newBounds) {
        if (newBounds.width != this.bounds.width) {
            if (this.isDefaultWidth()) {
                this.setDefaultWidth(false);
            }
            this.getParent().columnChange(this, newBounds);
        } else {
            this.bounds = newBounds;
        }
    }

    void setDefaultWidth(boolean isDefaultWidth) {
        this.isDefaultWidth = isDefaultWidth;
    }

    public void setImage(Image image) {
        super.setImage(image);
        Header header = this.parent.getHeader();
        header.setHeaderHeight();
        header.redraw();
        this.parent.redraw();
    }

    void setIndex(int newIndex) {
        this.index = newIndex;
    }

    public void setResizable(boolean resize) {
        this.checkWidget();
        this.resize = resize;
    }

    public void setText(String newText) {
        this.checkWidget();
        int index = this.getIndex();
        if (newText == null) {
            this.error(4);
        }
        if (!(index == -1 || this.text != null && this.text.equals(newText))) {
            super.setText(newText);
            this.getParent().getHeader().redraw(index);
        }
    }

    public void setWidth(int width) {
        this.checkWidget();
        Rectangle bounds = this.getBounds();
        int oldWidth = bounds.width;
        if (width != oldWidth) {
            int redrawX = bounds.x;
            bounds.width = width;
            this.setBounds(bounds);
            this.parent.redraw((redrawX += Math.min(width, oldWidth)) - 2, 0, 2, this.parent.getClientArea().height, false);
            this.sendEvent(11);
            int count = this.parent.getColumnCount();
            for (int i = this.index + 1; i < count; ++i) {
                this.parent.getColumn(i).sendEvent(10);
            }
        }
    }
}

