/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractViewerState {
    private List fExpandedElements = null;
    private IPath[] fSelection = null;

    public AbstractViewerState(TreeViewer viewer) {
        this.saveState(viewer);
    }

    public void saveState(TreeViewer viewer) {
        ArrayList expanded = new ArrayList();
        this.fExpandedElements = null;
        TreeItem[] items = viewer.getTree().getItems();
        try {
            for (int i = 0; i < items.length; ++i) {
                this.collectExandedItems(items[i], expanded);
            }
            if (expanded.size() > 0) {
                this.fExpandedElements = expanded;
            }
        }
        catch (DebugException e) {
            this.fExpandedElements = null;
        }
        TreeItem[] selection = viewer.getTree().getSelection();
        this.fSelection = new IPath[selection.length];
        try {
            for (int i = 0; i < selection.length; ++i) {
                this.fSelection[i] = this.encodeElement(selection[i]);
            }
        }
        catch (DebugException e) {
            this.fSelection = null;
        }
    }

    protected void collectExandedItems(TreeItem item, List expanded) throws DebugException {
        if (item.getExpanded()) {
            expanded.add(this.encodeElement(item));
            TreeItem[] items = item.getItems();
            for (int i = 0; i < items.length; ++i) {
                this.collectExandedItems(items[i], expanded);
            }
        }
    }

    protected abstract IPath encodeElement(TreeItem var1) throws DebugException;

    public void restoreState(TreeViewer viewer) {
        Object obj;
        IPath path;
        int i;
        if (this.fExpandedElements != null) {
            ArrayList<Object> expansion = new ArrayList<Object>(this.fExpandedElements.size());
            for (i = 0; i < this.fExpandedElements.size(); ++i) {
                path = (IPath)this.fExpandedElements.get(i);
                if (path == null) continue;
                try {
                    obj = this.decodePath(path, viewer);
                    if (obj == null) continue;
                    expansion.add(obj);
                    continue;
                }
                catch (DebugException e) {
                    // empty catch block
                }
            }
            viewer.setExpandedElements(expansion.toArray());
        }
        if (this.fSelection != null) {
            ArrayList<Object> selection = new ArrayList<Object>(this.fSelection.length);
            for (i = 0; i < this.fSelection.length; ++i) {
                path = this.fSelection[i];
                try {
                    obj = this.decodePath(path, viewer);
                    if (obj == null) continue;
                    selection.add(obj);
                    continue;
                }
                catch (DebugException e) {
                    // empty catch block
                }
            }
            viewer.setSelection((ISelection)new StructuredSelection(selection));
        }
    }

    protected abstract Object decodePath(IPath var1, TreeViewer var2) throws DebugException;
}

