/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.context;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.IModelUndoManager;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.IInputContextListener;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public abstract class InputContextManager
implements IResourceChangeListener {
    private PDEFormEditor editor;
    private Hashtable inputContexts;
    private ArrayList monitoredFiles;
    private ArrayList listeners;
    private IModelUndoManager undoManager;

    public InputContextManager(PDEFormEditor editor) {
        this.editor = editor;
        this.inputContexts = new Hashtable();
        this.listeners = new ArrayList();
        PDEPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void addInputContextListener(IInputContextListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeInputContextListener(IInputContextListener listener) {
        this.listeners.remove(listener);
    }

    public void dispose() {
        PDEPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        Enumeration enumeration = this.inputContexts.elements();
        while (enumeration.hasMoreElements()) {
            InputContext context = (InputContext)enumeration.nextElement();
            this.unhookUndo(context);
            context.dispose();
        }
        this.inputContexts.clear();
        this.undoManager = null;
    }

    public void save(IProgressMonitor monitor) {
        Enumeration enumeration = this.inputContexts.elements();
        while (enumeration.hasMoreElements()) {
            InputContext context = (InputContext)enumeration.nextElement();
            if (!context.mustSave()) continue;
            context.doSave(monitor);
        }
    }

    public IProject getCommonProject() {
        Enumeration enumeration = this.inputContexts.elements();
        while (enumeration.hasMoreElements()) {
            InputContext context = (InputContext)enumeration.nextElement();
            IEditorInput input = context.getInput();
            if (!(input instanceof IFileEditorInput)) continue;
            return ((IFileEditorInput)input).getFile().getProject();
        }
        return null;
    }

    public boolean hasContext(String id) {
        return this.findContext(id) != null;
    }

    public InputContext findContext(String id) {
        Enumeration enumeration = this.inputContexts.elements();
        while (enumeration.hasMoreElements()) {
            InputContext context = (InputContext)enumeration.nextElement();
            if (!context.getId().equals(id)) continue;
            return context;
        }
        return null;
    }

    public InputContext findContext(IResource resource) {
        Enumeration enumeration = this.inputContexts.elements();
        while (enumeration.hasMoreElements()) {
            InputContext context = (InputContext)enumeration.nextElement();
            if (!context.matches(resource)) continue;
            return context;
        }
        return null;
    }

    public IBaseModel getAggregateModel() {
        return null;
    }

    public InputContext getContext(IEditorInput input) {
        return (InputContext)this.inputContexts.get(input);
    }

    public void putContext(IEditorInput input, InputContext context) {
        this.inputContexts.put(input, context);
        this.fireContextChange(context, true);
    }

    public InputContext getPrimaryContext() {
        Enumeration enumeration = this.inputContexts.elements();
        while (enumeration.hasMoreElements()) {
            InputContext context = (InputContext)enumeration.nextElement();
            if (!context.isPrimary()) continue;
            return context;
        }
        return null;
    }

    public InputContext[] getInvalidContexts() {
        ArrayList<InputContext> result = new ArrayList<InputContext>();
        Enumeration enumeration = this.inputContexts.elements();
        while (enumeration.hasMoreElements()) {
            InputContext context = (InputContext)enumeration.nextElement();
            if (context.isModelCorrect()) continue;
            result.add(context);
        }
        return result.toArray(new InputContext[result.size()]);
    }

    public boolean isDirty() {
        Enumeration enumeration = this.inputContexts.elements();
        while (enumeration.hasMoreElements()) {
            InputContext context = (InputContext)enumeration.nextElement();
            if (!context.mustSave()) continue;
            return true;
        }
        return false;
    }

    public void monitorFile(IFile file) {
        if (this.monitoredFiles == null) {
            this.monitoredFiles = new ArrayList();
        }
        this.monitoredFiles.add(file);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    int kind = delta.getKind();
                    IResource resource = delta.getResource();
                    if (resource instanceof IFile) {
                        if (kind == 1) {
                            InputContextManager.this.asyncStructureChanged((IFile)resource, true);
                        } else if (kind == 2) {
                            InputContextManager.this.asyncStructureChanged((IFile)resource, false);
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void asyncStructureChanged(final IFile file, final boolean added) {
        if (this.editor == null || this.editor.getEditorSite() == null) {
            return;
        }
        this.editor.getEditorSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                InputContextManager.this.structureChanged(file, added);
            }
        });
    }

    private void structureChanged(IFile file, boolean added) {
        if (this.monitoredFiles == null) {
            return;
        }
        for (int i = 0; i < this.monitoredFiles.size(); ++i) {
            IFile ifile = (IFile)this.monitoredFiles.get(i);
            if (!ifile.equals(file)) continue;
            if (added) {
                this.fireStructureChange(file, true);
                continue;
            }
            this.fireStructureChange(file, false);
            this.removeContext(file);
        }
    }

    private void removeContext(IFile file) {
        Enumeration enumeration = this.inputContexts.elements();
        while (enumeration.hasMoreElements()) {
            IFileEditorInput fileInput;
            InputContext context = (InputContext)enumeration.nextElement();
            IEditorInput input = context.getInput();
            if (!(input instanceof IFileEditorInput) || !file.equals((fileInput = (IFileEditorInput)input).getFile())) continue;
            this.inputContexts.remove(input);
            this.fireContextChange(context, false);
            return;
        }
    }

    protected void fireStructureChange(IFile file, boolean added) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            IInputContextListener listener = (IInputContextListener)this.listeners.get(i);
            if (added) {
                listener.monitoredFileAdded(file);
                continue;
            }
            listener.monitoredFileRemoved(file);
        }
    }

    protected void fireContextChange(InputContext context, boolean added) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            IInputContextListener listener = (IInputContextListener)this.listeners.get(i);
            if (added) {
                listener.contextAdded(context);
                continue;
            }
            listener.contextRemoved(context);
        }
        if (added) {
            this.hookUndo(context);
        } else {
            this.unhookUndo(context);
        }
    }

    public void undo() {
        if (this.undoManager != null && this.undoManager.isUndoable()) {
            this.undoManager.undo();
        }
    }

    public void redo() {
        if (this.undoManager != null && this.undoManager.isRedoable()) {
            this.undoManager.redo();
        }
    }

    private void hookUndo(InputContext context) {
        if (this.undoManager == null) {
            return;
        }
        IBaseModel model = context.getModel();
        if (model instanceof IModelChangeProvider) {
            this.undoManager.connect((IModelChangeProvider)model);
        }
    }

    private void unhookUndo(InputContext context) {
        if (this.undoManager == null) {
            return;
        }
        IBaseModel model = context.getModel();
        if (model instanceof IModelChangeProvider) {
            this.undoManager.disconnect((IModelChangeProvider)model);
        }
    }

    public IModelUndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(IModelUndoManager undoManager) {
        this.undoManager = undoManager;
    }
}

