/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.internal.core.Choice;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class PortabilityChoicesDialog
extends Dialog {
    private static final String KEY_CHOICES = "FeatureEditor.PortabilityChoicesDialog.choices";
    private String value;
    private Choice[] choices;
    private CheckboxTableViewer choiceViewer;
    private WizardCheckboxTablePart checkboxTablePart;

    public PortabilityChoicesDialog(Shell shell, Choice[] choices, String value) {
        super(shell);
        this.value = value;
        this.choices = choices;
        this.checkboxTablePart = new WizardCheckboxTablePart(PDEPlugin.getResourceString(KEY_CHOICES));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 9;
        layout.marginWidth = 9;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.checkboxTablePart.createControl(container);
        this.choiceViewer = this.checkboxTablePart.getTableViewer();
        this.choiceViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.choiceViewer.setLabelProvider((IBaseLabelProvider)new ChoiceLabelProvider());
        gd = (GridData)this.checkboxTablePart.getControl().getLayoutData();
        gd.widthHint = 300;
        gd.heightHint = 350;
        this.initialize();
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.feature_portability_wizard");
        return container;
    }

    public String getValue() {
        return this.value;
    }

    protected void initialize() {
        this.choiceViewer.setInput((Object)PDEPlugin.getDefault());
        if (this.value != null) {
            Vector<Choice> selected = new Vector<Choice>();
            StringTokenizer stok = new StringTokenizer(this.value, ",");
            while (stok.hasMoreElements()) {
                String tok = stok.nextToken();
                Choice choice = this.findChoice(tok);
                if (choice == null) continue;
                selected.add(choice);
            }
            this.checkboxTablePart.setSelection(selected.toArray());
        } else {
            this.checkboxTablePart.selectAll(false);
        }
    }

    private Choice findChoice(String value) {
        for (int i = 0; i < this.choices.length; ++i) {
            Choice choice = this.choices[i];
            if (!choice.getValue().equalsIgnoreCase(value)) continue;
            return choice;
        }
        return null;
    }

    protected void okPressed() {
        this.value = this.computeNewValue();
        super.okPressed();
    }

    private String computeNewValue() {
        Object[] checked = this.checkboxTablePart.getSelection();
        if (checked.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < checked.length; ++i) {
            Choice choice = (Choice)checked[i];
            if (i > 0) {
                buf.append(",");
            }
            buf.append(choice.getValue());
        }
        return buf.toString();
    }

    class ChoiceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ChoiceLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return ((Choice)obj).getLabel();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    class ContentProvider
    extends DefaultTableProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return PortabilityChoicesDialog.this.choices;
        }
    }
}

