/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.feature;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.feature.BasePluginListPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class PluginListPage
extends BasePluginListPage {
    public static final String PAGE_TITLE = "NewFeatureWizard.PlugPage.title";
    public static final String PAGE_DESC = "NewFeatureWizard.PlugPage.desc";
    private IPluginModelBase[] models;

    public PluginListPage() {
        super("pluginListPage");
        this.setTitle(PDEPlugin.getResourceString(PAGE_TITLE));
        this.setDescription(PDEPlugin.getResourceString(PAGE_DESC));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        container.setLayout((Layout)layout);
        this.tablePart.createControl(container);
        CheckboxTableViewer pluginViewer = this.tablePart.getTableViewer();
        pluginViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        pluginViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        pluginViewer.setSorter(ListUtil.PLUGIN_SORTER);
        GridData gd = (GridData)this.tablePart.getControl().getLayoutData();
        gd.heightHint = 250;
        pluginViewer.setInput((Object)PDECore.getDefault().getWorkspaceModelManager());
        this.tablePart.setSelection(new Object[0]);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.new_feature_referenced_plugins");
    }

    private Object[] getPluginModels() {
        if (this.models == null) {
            WorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
            IPluginModel[] workspaceModels = manager.getPluginModels();
            IFragmentModel[] fragmentModels = manager.getFragmentModels();
            this.models = new IPluginModelBase[workspaceModels.length + fragmentModels.length];
            System.arraycopy(workspaceModels, 0, this.models, 0, workspaceModels.length);
            System.arraycopy(fragmentModels, 0, this.models, workspaceModels.length, fragmentModels.length);
        }
        return this.models;
    }

    public IPluginBase[] getSelectedPlugins() {
        Object[] result = this.tablePart.getSelection();
        IPluginBase[] plugins = new IPluginBase[result.length];
        for (int i = 0; i < result.length; ++i) {
            IPluginModelBase model = (IPluginModelBase)result[i];
            plugins[i] = model.getPluginBase();
        }
        return plugins;
    }

    class PluginContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        PluginContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return PluginListPage.this.getPluginModels();
        }
    }
}

