/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.internal.misc.StringMatcher;

public class PatternFilter
extends ViewerFilter {
    private Map cache = new HashMap();
    private StringMatcher matcher;

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        if (this.matcher == null) {
            return elements;
        }
        Object[] filtered = (Object[])this.cache.get(parent);
        if (filtered == null) {
            filtered = super.filter(viewer, parent, elements);
            this.cache.put(parent, filtered);
        }
        return filtered;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
        if (children.length > 0) {
            return this.filter(viewer, element, children).length > 0;
        }
        String labelText = ((ILabelProvider)((StructuredViewer)viewer).getLabelProvider()).getText(element);
        return this.match(labelText);
    }

    public void setPattern(String patternString) {
        this.cache.clear();
        this.matcher = patternString == null || patternString.equals("") ? null : new StringMatcher(patternString + "*", true, false);
    }

    protected boolean match(String string) {
        return this.matcher.match(string);
    }
}

