/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.model.AdaptableList;

public class WizardContentProvider
implements ITreeContentProvider {
    private AdaptableList input;

    public void dispose() {
        this.input = null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof WizardCollectionElement) {
            ArrayList list = new ArrayList();
            WizardCollectionElement element = (WizardCollectionElement)parentElement;
            Object[] childCollections = element.getChildren();
            for (int i = 0; i < childCollections.length; ++i) {
                this.handleChild(childCollections[i], list);
            }
            Object[] childWizards = element.getWizards();
            for (int i = 0; i < childWizards.length; ++i) {
                this.handleChild(childWizards[i], list);
            }
            if (list.size() == 1 && list.get(0) instanceof WizardCollectionElement) {
                return this.getChildren(list.get(0));
            }
            return list.toArray();
        }
        if (parentElement instanceof AdaptableList) {
            AdaptableList aList = (AdaptableList)parentElement;
            Object[] children = aList.getChildren();
            ArrayList list = new ArrayList(children.length);
            for (int i = 0; i < children.length; ++i) {
                this.handleChild(children[i], list);
            }
            return list.toArray();
        }
        return new Object[0];
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        if (element instanceof WizardCollectionElement) {
            Object[] children = this.input.getChildren();
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].equals(element)) continue;
                return this.input;
            }
            return ((WizardCollectionElement)element).getParent(element);
        }
        return null;
    }

    private void handleChild(Object element, ArrayList list) {
        if (element instanceof WizardCollectionElement) {
            if (this.hasChildren(element)) {
                list.add(element);
            }
        } else {
            list.add(element);
        }
    }

    public boolean hasChildren(Object element) {
        return element instanceof WizardCollectionElement && this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.input = (AdaptableList)newInput;
    }
}

