/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.registry.IStickyViewDescriptor;

public class StickyViewDescriptor
implements IStickyViewDescriptor {
    private static final String ATT_ID = "id";
    private static final String ATT_LOCATION = "location";
    private static final String ATT_CLOSEABLE = "closeable";
    private static final String ATT_MOVEABLE = "moveable";
    private String id;
    private String namespace;
    private int direction = 2;
    private boolean closeable = true;
    private boolean moveable = true;

    public StickyViewDescriptor(IConfigurationElement singleton) throws CoreException {
        String moveableString;
        String closeableString;
        this.id = singleton.getAttribute(ATT_ID);
        if (this.id == null) {
            throw new CoreException((IStatus)new Status(4, singleton.getDeclaringExtension().getNamespace(), 0, "Invalid extension (missing id) ", null));
        }
        this.namespace = singleton.getDeclaringExtension().getNamespace();
        String location = singleton.getAttribute(ATT_LOCATION);
        if (location != null) {
            if (location.equalsIgnoreCase("left")) {
                this.direction = 1;
            } else if (location.equalsIgnoreCase("top")) {
                this.direction = 3;
            } else if (location.equalsIgnoreCase("bottom")) {
                this.direction = 4;
            }
        }
        if ((closeableString = singleton.getAttribute(ATT_CLOSEABLE)) != null) {
            boolean bl = this.closeable = !closeableString.equals("false");
        }
        if ((moveableString = singleton.getAttribute(ATT_MOVEABLE)) != null) {
            this.moveable = !moveableString.equals("false");
        }
    }

    public int getLocation() {
        return this.direction;
    }

    public String getId() {
        return this.id;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public boolean isMoveable() {
        return this.moveable;
    }
}

