/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.IImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

public class AddUnimplementedConstructorsOperation
implements IWorkspaceRunnable {
    private IJavaElement fInsertPosition;
    private IMethod[] fSelected;
    private IType fType;
    private IMethod[] fCreatedMethods;
    private boolean fDoSave;
    private CodeGenerationSettings fSettings;
    private int fVisibility;
    private boolean fOmitSuper;

    public AddUnimplementedConstructorsOperation(IType type, CodeGenerationSettings settings, IMethod[] selected, boolean save, IJavaElement insertPosition) {
        this.fType = type;
        this.fDoSave = save;
        this.fCreatedMethods = null;
        this.fSettings = settings;
        this.fSelected = selected;
        this.fInsertPosition = insertPosition;
        this.fVisibility = 0;
        this.fOmitSuper = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.setTaskName(CodeGenerationMessages.getString("AddUnimplementedMethodsOperation.description"));
            monitor.beginTask("", 3);
            ITypeHierarchy hierarchy = this.fType.newSupertypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            monitor.worked(1);
            ImportsStructure imports = new ImportsStructure(this.fType.getCompilationUnit(), this.fSettings.importOrder, this.fSettings.importThreshold, true);
            String[] toImplement = this.genOverrideStubs(this.fSelected, this.fType, hierarchy, this.fSettings, imports);
            int nToImplement = toImplement.length;
            ArrayList<IMethod> createdMethods = new ArrayList<IMethod>(nToImplement);
            if (nToImplement > 0) {
                String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)this.fType);
                int indent = StubUtility.getIndentUsed((IJavaElement)this.fType) + 1;
                for (int i = 0; i < nToImplement; ++i) {
                    String formattedContent = CodeFormatterUtil.format(4, toImplement[i], indent, null, lineDelim, this.fType.getJavaProject()) + lineDelim;
                    IMethod curr = this.fType.createMethod(formattedContent, this.fInsertPosition, true, null);
                    createdMethods.add(curr);
                }
                monitor.worked(1);
                imports.create(this.fDoSave, null);
                monitor.worked(1);
            } else {
                monitor.worked(2);
            }
            this.fCreatedMethods = new IMethod[createdMethods.size()];
            createdMethods.toArray(this.fCreatedMethods);
        }
        finally {
            monitor.done();
        }
    }

    private String[] genOverrideStubs(IMethod[] methodsToImplement, IType type, ITypeHierarchy hierarchy, CodeGenerationSettings settings, IImportsStructure imports) throws CoreException {
        StubUtility.GenStubSettings genStubSettings = new StubUtility.GenStubSettings(settings);
        genStubSettings.methodOverwrites = true;
        ICompilationUnit cu = type.getCompilationUnit();
        String[] result = new String[methodsToImplement.length];
        for (int i = 0; i < methodsToImplement.length; ++i) {
            IMethod curr = methodsToImplement[i];
            IMethod overrides = JavaModelUtil.findMethodImplementationInHierarchy(hierarchy, type, curr.getElementName(), curr.getParameterTypes(), curr.isConstructor());
            if (overrides != null) {
                curr = overrides;
                genStubSettings.callSuper = curr.getNumberOfParameters() != 0 || !this.isOmitSuper();
            }
            genStubSettings.methodModifiers = this.fVisibility | JdtFlags.clearAccessModifiers(curr.getFlags());
            IMethod desc = JavaModelUtil.findMethodDeclarationInHierarchy(hierarchy, type, curr.getElementName(), curr.getParameterTypes(), curr.isConstructor());
            if (desc == null) {
                desc = curr;
            }
            result[i] = StubUtility.genStub(cu, type.getElementName(), curr, desc.getDeclaringType(), genStubSettings, imports);
        }
        return result;
    }

    public IMethod[] getCreatedMethods() {
        return this.fCreatedMethods;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public void setVisibility(int visibility) {
        this.fVisibility = visibility;
    }

    public void setOmitSuper(boolean omitSuper) {
        this.fOmitSuper = omitSuper;
    }

    public boolean isOmitSuper() {
        return this.fOmitSuper;
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

