/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class SourceReferenceUtil {
    private SourceReferenceUtil() {
    }

    public static IFile getFile(ISourceReference ref) throws JavaModelException {
        ICompilationUnit unit = SourceReferenceUtil.getCompilationUnit(ref);
        return (IFile)JavaModelUtil.toOriginal(unit).getResource();
    }

    public static ICompilationUnit getCompilationUnit(ISourceReference o) {
        Assert.isTrue(!(o instanceof IClassFile));
        if (o instanceof ICompilationUnit) {
            return (ICompilationUnit)o;
        }
        if (o instanceof IJavaElement) {
            return (ICompilationUnit)((IJavaElement)o).getAncestor(5);
        }
        return null;
    }

    private static boolean hasParentInSet(IJavaElement elem, Set set) {
        for (IJavaElement parent = elem.getParent(); parent != null; parent = parent.getParent()) {
            if (!set.contains(parent)) continue;
            return true;
        }
        return false;
    }

    public static ISourceReference[] removeAllWithParentsSelected(ISourceReference[] elems) {
        HashSet<ISourceReference> set = new HashSet<ISourceReference>(Arrays.asList(elems));
        ArrayList<ISourceReference> result = new ArrayList<ISourceReference>(elems.length);
        for (int i = 0; i < elems.length; ++i) {
            ISourceReference elem = elems[i];
            if (!(elem instanceof IJavaElement)) {
                result.add(elem);
                continue;
            }
            if (SourceReferenceUtil.hasParentInSet((IJavaElement)elem, set)) continue;
            result.add(elem);
        }
        return result.toArray(new ISourceReference[result.size()]);
    }

    public static Map groupByFile(ISourceReference[] elems) throws JavaModelException {
        HashMap map = new HashMap();
        for (int i = 0; i < elems.length; ++i) {
            ISourceReference elem = elems[i];
            IFile file = SourceReferenceUtil.getFile(elem);
            if (!map.containsKey(file)) {
                map.put(file, new ArrayList());
            }
            ((List)map.get(file)).add(elem);
        }
        return map;
    }

    public static ISourceReference[] sortByOffset(ISourceReference[] methods) {
        Arrays.sort(methods, new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    return ((ISourceReference)o2).getSourceRange().getOffset() - ((ISourceReference)o1).getSourceRange().getOffset();
                }
                catch (JavaModelException e) {
                    return o2.hashCode() - o1.hashCode();
                }
            }
        });
        return methods;
    }
}

