/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.browsing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackagesProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

class PackagesViewHierarchicalContentProvider
extends LogicalPackagesProvider
implements ITreeContentProvider {
    public PackagesViewHierarchicalContentProvider(StructuredViewer viewer) {
        super(viewer);
    }

    public Object[] getChildren(Object parentElement) {
        try {
            if (parentElement instanceof IJavaElement) {
                IJavaElement iJavaElement = (IJavaElement)parentElement;
                int type = iJavaElement.getElementType();
                switch (type) {
                    case 2: {
                        this.fMapToLogicalPackage.clear();
                        this.fMapToPackageFragments.clear();
                        IJavaProject project = (IJavaProject)parentElement;
                        IPackageFragment[] topLevelChildren = this.getTopLevelChildrenByElementName((IJavaElement[])project.getPackageFragments());
                        ArrayList<IPackageFragment> list = new ArrayList<IPackageFragment>();
                        for (int i = 0; i < topLevelChildren.length; ++i) {
                            IPackageFragmentRoot root;
                            IPackageFragment fragment = topLevelChildren[i];
                            IJavaElement el = fragment.getParent();
                            if (!(el instanceof IPackageFragmentRoot) || (root = (IPackageFragmentRoot)el).isArchive() && root.isExternal()) continue;
                            list.add(fragment);
                        }
                        return this.combineSamePackagesIntoLogialPackages(list.toArray(new IPackageFragment[list.size()]));
                    }
                    case 3: {
                        IPackageFragmentRoot root = (IPackageFragmentRoot)parentElement;
                        this.fMapToLogicalPackage.clear();
                        this.fMapToPackageFragments.clear();
                        IResource resource = root.getUnderlyingResource();
                        Object[] fragments = new IPackageFragment[]{};
                        if (root.isArchive()) {
                            IJavaElement[] els = root.getChildren();
                            fragments = this.getTopLevelChildrenByElementName(els);
                        } else if (resource != null && resource instanceof IFolder) {
                            fragments = this.getTopLevelChildrenByElementName(root.getChildren());
                        }
                        this.addFragmentsToMap((IPackageFragment[])fragments);
                        return fragments;
                    }
                    case 4: {
                        IPackageFragment packageFragment = (IPackageFragment)parentElement;
                        Object[] fragments = new IPackageFragment[]{};
                        IJavaElement parent = packageFragment.getParent();
                        if (parent instanceof IPackageFragmentRoot) {
                            IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
                            fragments = this.findNextLevelChildrenByElementName(root, packageFragment);
                        }
                        this.addFragmentsToMap((IPackageFragment[])fragments);
                        return fragments;
                    }
                }
            } else if (parentElement instanceof LogicalPackage) {
                ArrayList<IPackageFragment> children = new ArrayList<IPackageFragment>();
                LogicalPackage logicalPackage = (LogicalPackage)((Object)parentElement);
                IPackageFragment[] elements = logicalPackage.getFragments();
                for (int i = 0; i < elements.length; ++i) {
                    IPackageFragment fragment = elements[i];
                    IPackageFragment[] objects = this.findNextLevelChildrenByElementName((IPackageFragmentRoot)fragment.getParent(), fragment);
                    children.addAll(Arrays.asList(objects));
                }
                return this.combineSamePackagesIntoLogialPackages(children.toArray(new IPackageFragment[children.size()]));
            }
        }
        catch (JavaModelException e) {
            return NO_CHILDREN;
        }
        return NO_CHILDREN;
    }

    private IPackageFragment[] findNextLevelChildrenByElementName(IPackageFragmentRoot parent, IPackageFragment fragment) {
        ArrayList<IPackageFragment> list = new ArrayList<IPackageFragment>();
        try {
            IJavaElement[] children = parent.getChildren();
            String fragmentname = fragment.getElementName();
            for (int i = 0; i < children.length; ++i) {
                String tail;
                IJavaElement element = children[i];
                if (!(element instanceof IPackageFragment)) continue;
                IPackageFragment frag = (IPackageFragment)element;
                String name = element.getElementName();
                if (name.length() <= fragmentname.length() || name.charAt(fragmentname.length()) != '.' || !frag.exists() || "".equals(fragmentname) || !name.startsWith(fragmentname) || name.equals(fragmentname) || "".equals(tail = name.substring(fragmentname.length() + 1)) || tail.indexOf(".") != -1) continue;
                list.add(frag);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return list.toArray(new IPackageFragment[list.size()]);
    }

    private IPackageFragment[] getTopLevelChildrenByElementName(IJavaElement[] elements) {
        ArrayList<IJavaElement> topLevelElements = new ArrayList<IJavaElement>();
        for (int i = 0; i < elements.length; ++i) {
            IJavaElement iJavaElement = elements[i];
            if (iJavaElement.getElementName().indexOf(".") != -1 || !(iJavaElement instanceof IPackageFragment)) continue;
            topLevelElements.add(iJavaElement);
        }
        return topLevelElements.toArray(new IPackageFragment[topLevelElements.size()]);
    }

    public Object getParent(Object element) {
        try {
            if (element instanceof IPackageFragment) {
                IPackageFragment fragment = (IPackageFragment)element;
                if (!fragment.exists()) {
                    return null;
                }
                Object parent = this.getHierarchicalParent(fragment);
                if (parent instanceof IPackageFragment) {
                    IPackageFragment pkgFragment = (IPackageFragment)parent;
                    LogicalPackage logicalPkg = this.findLogicalPackage(pkgFragment);
                    if (logicalPkg != null) {
                        return logicalPkg;
                    }
                    LogicalPackage lp = this.createLogicalPackage(pkgFragment);
                    if (lp == null) {
                        return pkgFragment;
                    }
                    return lp;
                }
                return parent;
            }
            if (element instanceof LogicalPackage) {
                LogicalPackage el = (LogicalPackage)((Object)element);
                IPackageFragment fragment = el.getFragments()[0];
                Object parent = this.getHierarchicalParent(fragment);
                if (parent instanceof IPackageFragment) {
                    IPackageFragment pkgFragment = (IPackageFragment)parent;
                    LogicalPackage logicalPkg = this.findLogicalPackage(pkgFragment);
                    if (logicalPkg != null) {
                        return logicalPkg;
                    }
                    LogicalPackage lp = this.createLogicalPackage(pkgFragment);
                    if (lp == null) {
                        return pkgFragment;
                    }
                    return lp;
                }
                return fragment.getJavaProject();
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    private LogicalPackage createLogicalPackage(IPackageFragment pkgFragment) {
        if (!this.fInputIsProject) {
            return null;
        }
        ArrayList<IPackageFragment> fragments = new ArrayList<IPackageFragment>();
        try {
            IPackageFragmentRoot[] roots = pkgFragment.getJavaProject().getPackageFragmentRoots();
            for (int i = 0; i < roots.length; ++i) {
                IPackageFragmentRoot root = roots[i];
                IPackageFragment fragment = root.getPackageFragment(pkgFragment.getElementName());
                if (!fragment.exists() || fragment.equals(pkgFragment)) continue;
                fragments.add(fragment);
            }
            if (!fragments.isEmpty()) {
                LogicalPackage logicalPackage = new LogicalPackage(pkgFragment);
                this.fMapToLogicalPackage.put(this.getKey(pkgFragment), logicalPackage);
                Iterator iter = fragments.iterator();
                while (iter.hasNext()) {
                    IPackageFragment f = (IPackageFragment)iter.next();
                    if (!logicalPackage.belongs(f)) continue;
                    logicalPackage.add(f);
                    this.fMapToLogicalPackage.put(this.getKey(f), logicalPackage);
                }
                return logicalPackage;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    private Object getHierarchicalParent(IPackageFragment fragment) throws JavaModelException {
        IJavaElement parent = fragment.getParent();
        if (parent instanceof IPackageFragmentRoot && parent.exists()) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
            if (root.isArchive() || !fragment.exists()) {
                return this.findNextLevelParentByElementName((IJavaElement)fragment, (IJavaElement)root);
            }
            IResource resource = fragment.getUnderlyingResource();
            if (resource != null && resource instanceof IFolder) {
                IFolder folder = (IFolder)resource;
                IContainer res = folder.getParent();
                IJavaElement el = JavaCore.create((IResource)res);
                return el;
            }
        }
        return parent;
    }

    private Object findNextLevelParentByElementName(IJavaElement child, IJavaElement parent) {
        String name = child.getElementName();
        if (name.indexOf(".") == -1) {
            return parent;
        }
        try {
            String realParentName = child.getElementName().substring(0, name.lastIndexOf("."));
            IJavaElement[] children = new IJavaElement[]{};
            if (parent instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
                children = root.getChildren();
            } else if (parent instanceof IJavaProject) {
                IJavaProject project = (IJavaProject)parent;
                children = project.getPackageFragments();
            }
            for (int i = 0; i < children.length; ++i) {
                IJavaElement element = children[i];
                if (!element.getElementName().equals(realParentName)) continue;
                return element;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        IPackageFragment fragment;
        if (element instanceof IPackageFragment && ((fragment = (IPackageFragment)element).isDefaultPackage() || !fragment.exists())) {
            return false;
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    protected void processDelta(IJavaElementDelta delta) throws JavaModelException {
        Object input;
        int kind = delta.getKind();
        IJavaElement element = delta.getElement();
        if (this.isClassPathChange(delta) && (input = this.fViewer.getInput()) != null) {
            if (this.fInputIsProject && input.equals(element.getJavaProject())) {
                this.postRefresh(input);
                return;
            }
            if (!this.fInputIsProject && input.equals(element)) {
                if (element.exists()) {
                    this.postRefresh(input);
                } else {
                    this.postRemove(input);
                }
                return;
            }
        }
        if (kind == 2 && (input = this.fViewer.getInput()) != null && input.equals(element)) {
            this.postRemove(input);
            return;
        }
        if (element instanceof IPackageFragment) {
            IPackageFragment frag = (IPackageFragment)element;
            if (kind == 2) {
                this.removeElement(frag);
                return;
            }
            if (kind == 1) {
                Object parent = this.getParent(frag);
                this.addElement(frag, parent);
                return;
            }
            if (kind == 4) {
                LogicalPackage logicalPkg = this.findLogicalPackage(frag);
                if (logicalPkg != null) {
                    this.postRefresh(this.findElementToRefresh((Object)logicalPkg));
                } else {
                    this.postRefresh(this.findElementToRefresh(frag));
                }
                return;
            }
        }
        this.processAffectedChildren(delta);
    }

    private Object findElementToRefresh(Object object) {
        Object toBeRefreshed = object;
        if (this.fViewer.testFindItem(object) == null) {
            Object parent = this.getParent(object);
            if (parent instanceof IPackageFragmentRoot && this.fInputIsProject) {
                parent = ((IPackageFragmentRoot)parent).getJavaProject();
            }
            if (parent != null) {
                toBeRefreshed = parent;
            }
        }
        return toBeRefreshed;
    }

    private void processAffectedChildren(IJavaElementDelta delta) throws JavaModelException {
        IJavaElementDelta[] affectedChildren = delta.getAffectedChildren();
        for (int i = 0; i < affectedChildren.length; ++i) {
            if (affectedChildren[i] instanceof ICompilationUnit) continue;
            this.processDelta(affectedChildren[i]);
        }
    }

    private void postAdd(final Object child, final Object parent) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = PackagesViewHierarchicalContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ((TreeViewer)PackagesViewHierarchicalContentProvider.this.fViewer).add(parent, child);
                }
            }
        });
    }

    private void postRemove(final Object object) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = PackagesViewHierarchicalContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ((TreeViewer)PackagesViewHierarchicalContentProvider.this.fViewer).remove(object);
                }
            }
        });
    }

    private void postRefresh(final Object object) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = PackagesViewHierarchicalContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ((TreeViewer)PackagesViewHierarchicalContentProvider.this.fViewer).refresh(object);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postRunnable(Runnable r) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            Display currentDisplay = Display.getCurrent();
            if (currentDisplay != null && currentDisplay.equals(ctrl.getDisplay())) {
                ctrl.getDisplay().syncExec(r);
            } else {
                ctrl.getDisplay().asyncExec(r);
            }
        }
    }

    private void addElement(IPackageFragment frag, Object parent) {
        String key = this.getKey(frag);
        LogicalPackage lp = (LogicalPackage)((Object)this.fMapToLogicalPackage.get(key));
        if (lp != null && lp.belongs(frag)) {
            lp.add(frag);
            return;
        }
        IPackageFragment iPackageFragment = (IPackageFragment)this.fMapToPackageFragments.get(key);
        if (iPackageFragment != null && !iPackageFragment.equals(frag)) {
            lp = new LogicalPackage(iPackageFragment);
            lp.add(frag);
            this.fMapToLogicalPackage.put(key, lp);
            if (parent instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
                if (this.fInputIsProject) {
                    this.postRefresh(root.getJavaProject());
                } else {
                    this.postRefresh(root);
                }
            } else {
                this.postAdd((Object)lp, parent);
                this.postRemove(iPackageFragment);
            }
        } else {
            this.fMapToPackageFragments.put(key, frag);
            if (parent instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
                if (this.fInputIsProject) {
                    this.postAdd(frag, root.getJavaProject());
                } else {
                    this.postAdd(frag, root);
                }
            } else {
                this.postAdd(frag, parent);
            }
        }
    }

    private void removeElement(IPackageFragment frag) {
        String key = this.getKey(frag);
        LogicalPackage lp = (LogicalPackage)((Object)this.fMapToLogicalPackage.get(key));
        if (lp != null) {
            lp.remove(frag);
            if (lp.getFragments().length == 1) {
                IPackageFragment fragment = lp.getFragments()[0];
                this.fMapToPackageFragments.put(key, fragment);
                this.fMapToLogicalPackage.remove(key);
                this.postRemove((Object)lp);
                Object parent = this.getParent(fragment);
                if (parent instanceof IPackageFragmentRoot) {
                    parent = ((IPackageFragmentRoot)parent).getJavaProject();
                }
                this.postAdd(fragment, parent);
            }
        } else {
            IPackageFragment fragment = (IPackageFragment)this.fMapToPackageFragments.get(key);
            if (fragment != null && fragment.equals(frag)) {
                this.fMapToPackageFragments.remove(key);
                this.postRemove(frag);
            }
        }
    }
}

