/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.data;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetManager;
import org.eclipse.ui.internal.cheatsheets.views.CoreItem;
import org.eclipse.ui.internal.cheatsheets.views.SubItemCompositeHolder;
import org.eclipse.ui.internal.cheatsheets.views.ViewItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class CheatSheetSaveHelper {
    private IPath savePath;
    protected Vector stateVector = new Vector();

    public CheatSheetSaveHelper() {
        this.savePath = Platform.getPluginStateLocation((Plugin)CheatSheetPlugin.getPlugin());
    }

    private Properties createProperties(int currentItemNum, ArrayList items, boolean buttonIsDown, ArrayList expandRestoreStates, String csID) {
        Properties props = new Properties();
        Hashtable<String, String> subcompletedTable = new Hashtable<String, String>(10);
        Hashtable<String, String> subskippedTable = new Hashtable<String, String>(10);
        int buttonState = 0;
        if (buttonIsDown) {
            buttonState = 1;
        }
        props.put("id", csID);
        props.put("current", Integer.toString(currentItemNum));
        ArrayList<String> completedList = new ArrayList<String>();
        ArrayList<String> expandedList = new ArrayList<String>();
        if (expandRestoreStates == null) {
            expandRestoreStates = new ArrayList();
        }
        for (int i = 0; i < items.size(); ++i) {
            CoreItem withsubs;
            ArrayList compList;
            ViewItem item = (ViewItem)items.get(i);
            if (item.isCompleted()) {
                completedList.add(Integer.toString(i));
            }
            if (item.isExpanded()) {
                expandedList.add(Integer.toString(i));
            }
            if (!(item instanceof CoreItem) || (compList = (withsubs = (CoreItem)item).getListOfSubItemCompositeHolders()) == null) continue;
            StringBuffer skippedsubItems = new StringBuffer();
            StringBuffer completedsubItems = new StringBuffer();
            for (int j = 0; j < compList.size(); ++j) {
                SubItemCompositeHolder sch = (SubItemCompositeHolder)compList.get(j);
                if (sch.isCompleted()) {
                    completedsubItems.append(Integer.toString(j) + ",");
                }
                if (!sch.isSkipped()) continue;
                skippedsubItems.append(Integer.toString(j) + ",");
            }
            if (completedsubItems.toString().length() > 0) {
                String csi = completedsubItems.toString();
                if (csi.endsWith(",")) {
                    csi = csi.substring(0, csi.length() - 1);
                }
                subcompletedTable.put(Integer.toString(i), csi);
            }
            if (skippedsubItems.toString().length() <= 0) continue;
            String csi = skippedsubItems.toString();
            if (csi.endsWith(",")) {
                csi = csi.substring(0, csi.length() - 1);
            }
            subskippedTable.put(Integer.toString(i), csi);
        }
        props.put("completed", completedList);
        props.put("expanded", expandedList);
        props.put("expandRestore", expandRestoreStates);
        props.put("button", Integer.toString(buttonState));
        if (subcompletedTable != null) {
            props.put("subitemcompleted", subcompletedTable);
        }
        if (subskippedTable != null) {
            props.put("subitemskipped", subskippedTable);
        }
        return props;
    }

    private String getAttributeWithName(NamedNodeMap map, String name) {
        try {
            return map.getNamedItem(name).getNodeValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    private ArrayList getMultipleAttributesWithSameName(NodeList nl, String name) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (int i = 0; i < nl.getLength(); ++i) {
            String value = nl.item(i).getAttributes().getNamedItem(name).getNodeValue();
            if (value == null) continue;
            returnList.add(value);
        }
        return returnList;
    }

    public Path getStateFile(String csID) {
        return new Path(this.savePath.append(csID + ".xml").toOSString());
    }

    public Properties loadState(String csID) {
        Properties returnProps = null;
        Hashtable<String, String> subskipped = null;
        Hashtable<String, String> subcompleted = null;
        Path filePath = this.getStateFile(csID);
        Document doc = null;
        URL readURL = null;
        try {
            readURL = filePath.toFile().toURL();
            doc = this.readXMLFile(readURL);
        }
        catch (MalformedURLException mue) {
            String message = CheatSheetPlugin.formatResourceString("%ERROR_CREATING_STATEFILE_URL", new Object[]{readURL});
            Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)mue);
            CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
            return null;
        }
        if (doc != null) {
            NodeList csmDatanl;
            Hashtable<String, String> ht = null;
            Element rootnode = doc.getDocumentElement();
            NamedNodeMap rootatts = rootnode.getAttributes();
            String currentID = this.getAttributeWithName(rootatts, "id");
            String number = this.getAttributeWithName(doc.getElementsByTagName("current").item(0).getAttributes(), "item");
            ArrayList completeList = this.getMultipleAttributesWithSameName(doc.getElementsByTagName("completed"), "item");
            ArrayList expandedList = this.getMultipleAttributesWithSameName(doc.getElementsByTagName("expanded"), "item");
            ArrayList expandRestoreList = this.getMultipleAttributesWithSameName(doc.getElementsByTagName("expandRestore"), "item");
            String buttonState = this.getAttributeWithName(doc.getElementsByTagName("button").item(0).getAttributes(), "buttonstate");
            NodeList nl = doc.getElementsByTagName("subitemcompleted");
            if (nl != null) {
                subcompleted = new Hashtable<String, String>(10);
            }
            for (int i = 0; i < nl.getLength(); ++i) {
                String item = this.getAttributeWithName(nl.item(i).getAttributes(), "item");
                String subItems = this.getAttributeWithName(nl.item(i).getAttributes(), "subitem");
                subcompleted.put(item, subItems);
            }
            NodeList snl = doc.getElementsByTagName("subitemskipped");
            if (snl != null) {
                subskipped = new Hashtable<String, String>(10);
                for (int i = 0; i < snl.getLength(); ++i) {
                    String item = this.getAttributeWithName(snl.item(i).getAttributes(), "item");
                    String subItems = this.getAttributeWithName(snl.item(i).getAttributes(), "subitem");
                    subskipped.put(item, subItems);
                }
            }
            if ((csmDatanl = doc.getElementsByTagName("CSMData")) != null) {
                ht = new Hashtable<String, String>(30);
                for (int i = 0; i < csmDatanl.getLength(); ++i) {
                    String key = null;
                    try {
                        key = this.getAttributeWithName(csmDatanl.item(i).getAttributes(), "key");
                        String data = csmDatanl.item(i).getFirstChild().getNodeValue();
                        ht.put(key, data);
                        continue;
                    }
                    catch (Exception e) {
                        String message = CheatSheetPlugin.formatResourceString("%ERROR_READING_MANAGERDATA_FROM_STATEFILE", new Object[]{key, currentID});
                        Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
                        CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
                    }
                }
            }
            returnProps = new Properties();
            returnProps.put("id", currentID);
            returnProps.put("current", number);
            returnProps.put("completed", completeList);
            returnProps.put("expanded", expandedList);
            returnProps.put("expandRestore", expandRestoreList);
            returnProps.put("button", buttonState);
            returnProps.put("subitemcompleted", subcompleted);
            returnProps.put("subitemskipped", subskipped);
            returnProps.put("CSMData", ht);
        }
        return returnProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Document readXMLFile(URL url) {
        InputStream is = null;
        InputSource source = null;
        try {
            is = url.openStream();
            if (is != null) {
                source = new InputSource(is);
            }
        }
        catch (Exception e) {
            return null;
        }
        if (source == null) {
            return null;
        }
        DocumentBuilder documentBuilder = CheatSheetPlugin.getPlugin().getDocumentBuilder();
        Document document = documentBuilder.parse(source);
        Object var7_8 = null;
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return document;
        catch (Exception e) {
            try {
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {}
        }
        return null;
    }

    private void saveState(Properties saveProperties, CheatSheetManager csm) {
        String csID = null;
        try {
            Element eRel;
            String subItemNum;
            String itemNum;
            int j;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = documentBuilder.newDocument();
            Properties properties = saveProperties;
            csID = (String)properties.get("id");
            String number = (String)properties.get("current");
            Path filePath = this.getStateFile(csID);
            ArrayList completedList = (ArrayList)properties.get("completed");
            ArrayList expandedList = (ArrayList)properties.get("expanded");
            ArrayList expandRestoreList = (ArrayList)properties.get("expandRestore");
            Hashtable subcompletedTable = (Hashtable)properties.get("subitemcompleted");
            Hashtable subskippedTable = (Hashtable)properties.get("subitemskipped");
            Element root = doc.createElement("cheatsheet");
            root.setAttribute("id", csID);
            doc.appendChild(root);
            Element cEl = doc.createElement("current");
            cEl.setAttribute("item", number);
            root.appendChild(cEl);
            for (j = 0; j < completedList.size(); ++j) {
                Element compEl = doc.createElement("completed");
                compEl.setAttribute("item", (String)completedList.get(j));
                root.appendChild(compEl);
            }
            for (j = 0; j < expandedList.size(); ++j) {
                Element expandEl = doc.createElement("expanded");
                expandEl.setAttribute("item", (String)expandedList.get(j));
                root.appendChild(expandEl);
            }
            for (j = 0; j < expandRestoreList.size(); ++j) {
                Element eRel2 = doc.createElement("expandRestore");
                eRel2.setAttribute("item", (String)expandRestoreList.get(j));
                root.appendChild(eRel2);
            }
            if (subcompletedTable != null) {
                Enumeration enumeration = subcompletedTable.keys();
                while (enumeration.hasMoreElements()) {
                    itemNum = (String)enumeration.nextElement();
                    subItemNum = (String)subcompletedTable.get(itemNum);
                    if (itemNum == null || subItemNum == null) continue;
                    eRel = doc.createElement("subitemcompleted");
                    eRel.setAttribute("item", itemNum);
                    eRel.setAttribute("subitem", subItemNum);
                    root.appendChild(eRel);
                }
            }
            if (subskippedTable != null) {
                Enumeration enumeration = subskippedTable.keys();
                while (enumeration.hasMoreElements()) {
                    itemNum = (String)enumeration.nextElement();
                    subItemNum = (String)subskippedTable.get(itemNum);
                    if (itemNum == null || subItemNum == null) continue;
                    eRel = doc.createElement("subitemskipped");
                    eRel.setAttribute("item", itemNum);
                    eRel.setAttribute("subitem", subItemNum);
                    root.appendChild(eRel);
                }
            }
            Element bel = doc.createElement("button");
            bel.setAttribute("buttonstate", (String)properties.get("button"));
            root.appendChild(bel);
            Hashtable managerData = (Hashtable)csm.getData();
            if (managerData != null) {
                Enumeration e = managerData.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String data = (String)managerData.get(key);
                    Element csmDataTag = doc.createElement("CSMData");
                    csmDataTag.setAttribute("key", key);
                    Text t = doc.createTextNode(data);
                    csmDataTag.appendChild(t);
                    root.appendChild(csmDataTag);
                }
            }
            StreamResult streamResult = new StreamResult(filePath.toFile());
            DOMSource domSource = new DOMSource(doc);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.transform(domSource, streamResult);
        }
        catch (Exception e) {
            String message = CheatSheetPlugin.formatResourceString("%ERROR_SAVING_STATEFILE_URL", new Object[]{csID});
            Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
            CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
        }
    }

    public void saveState(int currentItemNum, ArrayList items, boolean buttonIsDown, ArrayList expandRestoreStates, String csID, CheatSheetManager csm) {
        Properties properties = this.createProperties(currentItemNum, items, buttonIsDown, expandRestoreStates, csID);
        this.saveState(properties, csm);
    }
}

