/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.builders.CompilerFlags;

public class PDE
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.pde";
    public static final String MANIFEST_BUILDER_ID = "org.eclipse.pde.ManifestBuilder";
    public static final String SCHEMA_BUILDER_ID = "org.eclipse.pde.SchemaBuilder";
    public static final String PLUGIN_NATURE = "org.eclipse.pde.PluginNature";
    public static final String FEATURE_NATURE = "org.eclipse.pde.FeatureNature";
    public static final String SITE_NATURE = "org.eclipse.pde.UpdateSiteNature";
    public static final String FEATURE_BUILDER_ID = "org.eclipse.pde.FeatureBuilder";
    public static final String SITE_BUILDER_ID = "org.eclipse.pde.UpdateSiteBuilder";
    private static PDE inst;
    private ResourceBundle resourceBundle;

    public PDE(IPluginDescriptor descriptor) {
        super(descriptor);
        inst = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.pde.internal.pderesources");
        }
        catch (MissingResourceException x) {
            PDE.log(x);
            this.resourceBundle = null;
        }
    }

    public static boolean hasPluginNature(IProject project) {
        try {
            return project.hasNature(PLUGIN_NATURE);
        }
        catch (CoreException e) {
            PDE.log(e);
            return false;
        }
    }

    public static boolean hasFeatureNature(IProject project) {
        try {
            return project.hasNature(FEATURE_NATURE);
        }
        catch (CoreException e) {
            PDE.log(e);
            return false;
        }
    }

    public static PDE getDefault() {
        return inst;
    }

    public static String getFormattedMessage(String key, String[] args) {
        String text = PDE.getResourceString(key);
        return MessageFormat.format(text, args);
    }

    public static String getFormattedMessage(String key, String arg) {
        String text = PDE.getResourceString(key);
        return MessageFormat.format(text, arg);
    }

    static IPath getInstallLocation() {
        return new Path(PDE.getDefault().getDescriptor().getInstallURL().getFile());
    }

    public static String getPluginId() {
        return PDE.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PDE.getDefault().getResourceBundle();
        if (bundle != null) {
            try {
                String bundleString = bundle.getString(key);
                return bundleString;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return key;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        PDE.log((IStatus)new Status(4, PDE.getPluginId(), 4, message, null));
    }

    public static void logException(Throwable e, String title, String message) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            if (message == null) {
                message = e.getMessage();
            }
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, PDE.getPluginId(), 0, message, e);
        }
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void logException(Throwable e) {
        PDE.logException(e, null, null);
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, PDE.getPluginId(), 0, e.getMessage(), e);
        PDE.log(status);
    }

    public void startup() throws CoreException {
        super.startup();
        CompilerFlags.initializeDefaults();
    }
}

