/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.PDE;
import org.eclipse.pde.internal.builders.SchemaTransformer;
import org.eclipse.pde.internal.core.XMLDefaultHandler;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaDescriptor;
import org.eclipse.pde.internal.core.plugin.ExternalFragmentModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;
import org.eclipse.pde.internal.core.schema.Schema;
import org.xml.sax.helpers.DefaultHandler;

public class ConvertSchemaToHTML
extends Task {
    private SAXParser fParser;
    private SchemaTransformer fTransformer = new SchemaTransformer();
    private String manifest;
    private String destination;
    private URL cssURL = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (!this.validateDestination()) {
            return;
        }
        IPluginModelBase model = this.readManifestFile();
        if (model == null) {
            return;
        }
        String pluginID = model.getPluginBase().getId();
        if (pluginID == null) {
            pluginID = this.getPluginID();
        }
        IPluginExtensionPoint[] extPoints = model.getPluginBase().getExtensionPoints();
        int i = 0;
        while (true) {
            block26: {
                if (i >= extPoints.length) {
                    return;
                }
                String schemaLocation = extPoints[i].getSchema();
                PrintWriter out = null;
                if (schemaLocation != null && !schemaLocation.equals("")) {
                    Object var15_16;
                    Schema schema;
                    block25: {
                        block24: {
                            schema = null;
                            try {
                                try {
                                    File directory;
                                    if (this.fParser == null) {
                                        SAXParserFactory factory = SAXParserFactory.newInstance();
                                        this.fParser = factory.newSAXParser();
                                    }
                                    File schemaFile = new File(model.getInstallLocation(), schemaLocation);
                                    XMLDefaultHandler handler = new XMLDefaultHandler();
                                    this.fParser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
                                    this.fParser.parse(schemaFile, (DefaultHandler)handler);
                                    URL url = null;
                                    try {
                                        url = new URL("file:" + schemaFile.getAbsolutePath());
                                    }
                                    catch (MalformedURLException e) {
                                        // empty catch block
                                    }
                                    StandaloneSchemaDescriptor desc = new StandaloneSchemaDescriptor(extPoints[i], url);
                                    schema = (Schema)desc.getSchema();
                                    schema.traverseDocumentTree(handler.getDocumentElement(), handler.getLineTable());
                                    File file = directory = new Path(this.destination).isAbsolute() ? new File(this.destination) : new File(this.getProject().getBaseDir(), this.destination);
                                    if (!(directory.exists() && directory.isDirectory() || directory.mkdirs())) {
                                        schema.dispose();
                                        var15_16 = null;
                                        if (out != null) {
                                            out.close();
                                        }
                                        if (schema == null) {
                                            return;
                                        }
                                        break block24;
                                    }
                                    File file2 = new File(directory, (pluginID + "." + extPoints[i].getId()).replace('.', '_') + ".html");
                                    out = new PrintWriter((Writer)new FileWriter(file2), true);
                                    this.fTransformer.transform(out, (ISchema)schema, this.cssURL, (byte)1);
                                    break block25;
                                }
                                catch (Exception e) {
                                    if (e.getMessage() != null) {
                                        System.out.println(e.getMessage());
                                    }
                                    var15_16 = null;
                                    if (out != null) {
                                        out.close();
                                    }
                                    if (schema != null) {
                                        schema.dispose();
                                    }
                                    break block26;
                                }
                            }
                            catch (Throwable throwable) {
                                var15_16 = null;
                                if (out != null) {
                                    out.close();
                                }
                                if (schema == null) throw throwable;
                                schema.dispose();
                                throw throwable;
                            }
                        }
                        schema.dispose();
                        return;
                    }
                    var15_16 = null;
                    if (out != null) {
                        out.close();
                    }
                    if (schema != null) {
                        schema.dispose();
                    }
                }
            }
            ++i;
        }
    }

    private String getPluginID() {
        File file = new Path(this.manifest).isAbsolute() ? new File(this.manifest) : new File(this.getProject().getBaseDir(), this.manifest);
        File OSGiFile = new File(file.getParentFile(), "META-INF/MANIFEST.MF");
        if (OSGiFile.exists()) {
            try {
                Manifest OSGiManifest = new Manifest(new FileInputStream(OSGiFile));
                Properties headers = this.manifestToProperties(OSGiManifest.getMainAttributes());
                String value = ((Dictionary)headers).get("Bundle-SymbolicName").toString();
                if (value == null) {
                    return null;
                }
                ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)value);
                if (elements.length > 0) {
                    return elements[0].getValue();
                }
            }
            catch (Exception e1) {
                System.out.print(e1.getMessage());
            }
        }
        return null;
    }

    public void setManifest(String manifest) {
        this.manifest = manifest;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public URL getCSSURL() {
        return this.cssURL;
    }

    public void setCSSURL(String url) {
        try {
            this.cssURL = new URL(url);
        }
        catch (MalformedURLException e) {
            PDE.logException((Throwable)e);
        }
    }

    public void setCSSURL(URL url) {
        this.cssURL = url;
    }

    private IPluginModelBase readManifestFile() {
        ExternalFragmentModel model;
        block10: {
            if (this.manifest == null) {
                System.out.println(PDE.getFormattedMessage((String)"Builders.Convert.missingAttribute", (String)"manifest"));
                return null;
            }
            File file = new Path(this.manifest).isAbsolute() ? new File(this.manifest) : new File(this.getProject().getBaseDir(), this.manifest);
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(file);
            }
            catch (Exception e) {
                if (e.getMessage() != null) {
                    System.out.println(e.getMessage());
                }
                return null;
            }
            model = null;
            try {
                if (file.getName().toLowerCase().equals("fragment.xml")) {
                    model = new ExternalFragmentModel();
                } else if (file.getName().toLowerCase().equals("plugin.xml")) {
                    model = new ExternalPluginModel();
                } else {
                    System.out.println(PDE.getFormattedMessage((String)"Builders.Convert.illegalValue", (String)"manifest"));
                    return null;
                }
                String parentPath = file.getParentFile().getAbsolutePath();
                model.setInstallLocation(parentPath);
                model.load((InputStream)stream, false);
                ((InputStream)stream).close();
            }
            catch (Exception e) {
                if (e.getMessage() == null) break block10;
                System.out.println(e.getMessage());
            }
        }
        return model;
    }

    private Properties manifestToProperties(Attributes d) {
        Iterator<Object> iter = d.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            Attributes.Name key = (Attributes.Name)iter.next();
            result.put(key.toString(), d.get(key));
        }
        return result;
    }

    private boolean validateDestination() {
        boolean valid = true;
        if (this.destination == null) {
            System.out.println(PDE.getFormattedMessage((String)"Builders.Convert.missingAttribute", (String)"destination"));
            valid = false;
        } else if (!new Path(this.destination).isValidPath(this.destination)) {
            System.out.println(PDE.getFormattedMessage((String)"Builders.Convert.illegalValue", (String)"destination"));
            valid = false;
        }
        return valid;
    }

    private static class StandaloneSchemaDescriptor
    implements ISchemaDescriptor {
        private IPluginExtensionPoint point;
        private URL url;
        private ISchema schema;

        public StandaloneSchemaDescriptor(IPluginExtensionPoint point, URL url) {
            this.point = point;
            this.url = url;
            this.schema = new Schema((ISchemaDescriptor)this, url);
        }

        public IPath getPluginRelativePath(String id, IPath schemaPath) {
            IPluginModelBase model = (IPluginModelBase)this.point.getModel();
            String location = model.getInstallLocation();
            Path path = new Path(location);
            return path.removeLastSegments(1).append(id).append(schemaPath);
        }

        public URL getSchemaURL() {
            return this.url;
        }

        public String getPointId() {
            return this.point.getFullId();
        }

        public ISchema getSchema() {
            return this.schema;
        }

        public boolean isStandalone() {
            return true;
        }
    }
}

