/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.model;

import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IFeatureContentProvider;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IInstallHandlerEntry;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.ui.UpdateUI;

public class MissingFeature
implements IFeature {
    private URL url;
    private ISite site;
    private IFeatureReference reference;
    private IFeature parent;
    private IURLEntry desc;
    private VersionedIdentifier id = new VersionedIdentifier(UpdateUI.getString("MissingFeature.id"), "0.0.0");

    public MissingFeature(ISite site, URL url) {
        this.site = site;
        this.url = url;
        this.desc = new IURLEntry(){

            public URL getURL() {
                return null;
            }

            public String getAnnotation() {
                return UpdateUI.getString("MissingFeature.desc.unknown");
            }

            public Object getAdapter(Class key) {
                return null;
            }

            public int getType() {
                return 0;
            }
        };
    }

    public MissingFeature(IFeatureReference ref) {
        this(null, ref);
    }

    public MissingFeature(IFeature parent, IFeatureReference ref) {
        this(ref.getSite(), ref.getURL());
        this.reference = ref;
        this.parent = parent;
        if (this.isOptional()) {
            this.desc = new IURLEntry(){

                public URL getURL() {
                    return null;
                }

                public String getAnnotation() {
                    return UpdateUI.getString("MissingFeature.desc.optional");
                }

                public Object getAdapter(Class key) {
                    return null;
                }

                public int getType() {
                    return 0;
                }
            };
        }
    }

    public boolean isOptional() {
        return this.reference != null && this.reference instanceof IIncludedFeatureReference && ((IIncludedFeatureReference)this.reference).isOptional();
    }

    public IFeature getParent() {
        return this.parent;
    }

    public URL getOriginatingSiteURL() {
        VersionedIdentifier vid = this.getVersionedIdentifier();
        if (vid == null) {
            return null;
        }
        String key = vid.getIdentifier();
        return UpdateUI.getOriginatingURL(key);
    }

    public VersionedIdentifier getVersionedIdentifier() {
        if (this.reference != null) {
            try {
                return this.reference.getVersionedIdentifier();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return this.id;
    }

    public ISite getSite() {
        return this.site;
    }

    public String getLabel() {
        String name;
        if (this.reference != null && this.reference instanceof IIncludedFeatureReference && (name = ((IIncludedFeatureReference)this.reference).getName()) != null) {
            return name;
        }
        return this.url.toString();
    }

    public URL getURL() {
        return this.url;
    }

    public IURLEntry getUpdateSiteEntry() {
        return null;
    }

    public IURLEntry[] getDiscoverySiteEntries() {
        return null;
    }

    public String getProvider() {
        return UpdateUI.getString("MissingFeature.provider");
    }

    public IURLEntry getDescription() {
        return this.desc;
    }

    public IURLEntry getCopyright() {
        return null;
    }

    public IURLEntry getLicense() {
        return null;
    }

    public String getOS() {
        return null;
    }

    public String getWS() {
        return null;
    }

    public String getNL() {
        return null;
    }

    public String getOSArch() {
        return null;
    }

    public URL getImage() {
        return null;
    }

    public IImport[] getImports() {
        return null;
    }

    public String[] getArchives() {
        return null;
    }

    public INonPluginEntry[] getNonPluginEntries() {
        return null;
    }

    public void addNonPluginEntry(INonPluginEntry dataEntry) {
    }

    public long getDownloadSize() {
        return 0L;
    }

    public long getInstallSize() {
        return 0L;
    }

    public boolean isPrimary() {
        return false;
    }

    public String getApplication() {
        return null;
    }

    public IPluginEntry[] getPluginEntries() {
        return new IPluginEntry[0];
    }

    public int getPluginEntryCount() {
        return 0;
    }

    public long getDownloadSize(IPluginEntry entry) {
        return 0L;
    }

    public long getInstallSize(IPluginEntry entry) {
        return 0L;
    }

    public void addPluginEntry(IPluginEntry pluginEntry) {
    }

    public void store(IPluginEntry entry, String name, InputStream inStream) throws CoreException {
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void remove(IPluginEntry entry) throws CoreException {
    }

    public void setFeatureContentProvider(IFeatureContentProvider featureContentProvider) {
    }

    public IFeatureContentConsumer getFeatureContentConsumer() throws CoreException {
        return null;
    }

    public void setSite(ISite site) throws CoreException {
        this.site = site;
    }

    public IFeatureContentProvider getFeatureContentProvider() throws CoreException {
        return null;
    }

    public IFeatureReference install(IFeature targetFeature, IVerificationListener verificationListener, IProgressMonitor monitor) throws CoreException {
        return null;
    }

    public IFeatureReference install(IFeature targetFeature, IFeatureReference[] optionalFeatures, IVerificationListener verificationListener, IProgressMonitor monitor) throws InstallAbortedException, CoreException {
        return null;
    }

    public void remove(IProgressMonitor monitor) throws CoreException {
    }

    public void remove(IPluginEntry entry, IProgressMonitor monitor) throws CoreException {
    }

    public int getNonPluginEntryCount() {
        return 0;
    }

    public IInstallHandlerEntry getInstallHandlerEntry() {
        return null;
    }

    public IIncludedFeatureReference[] getIncludedFeatureReferences() throws CoreException {
        return new IIncludedFeatureReference[0];
    }

    public String getAffinityFeature() {
        return null;
    }

    public IIncludedFeatureReference[] getRawIncludedFeatureReferences() throws CoreException {
        return this.getIncludedFeatureReferences();
    }

    public INonPluginEntry[] getRawNonPluginEntries() {
        return this.getNonPluginEntries();
    }

    public IPluginEntry[] getRawPluginEntries() {
        return this.getPluginEntries();
    }

    public String getPrimaryPluginID() {
        return null;
    }

    public IImport[] getRawImports() {
        return new IImport[0];
    }

    public boolean isPatch() {
        return false;
    }

    public boolean isExclusive() {
        return false;
    }
}

