/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.search.internal.core.SearchScope;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.ui.IWorkingSet;

public class TextSearchScope
extends SearchScope {
    private Set fExtensions = new HashSet(3);
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public static TextSearchScope newWorkspaceScope() {
        return new WorkspaceScope();
    }

    public TextSearchScope(String description) {
        super(description);
    }

    public TextSearchScope(String description, IResource[] resources) {
        super(description, resources);
    }

    public TextSearchScope(String description, IAdaptable[] elements) {
        super(description, TextSearchScope.convertToResources(elements));
    }

    public TextSearchScope(String description, IWorkingSet[] workingSets) {
        super(description, TextSearchScope.convertToResources(TextSearchScope.getElements(workingSets)));
    }

    private static IResource[] convertToResources(IAdaptable[] elements) {
        int length = elements.length;
        HashSet<IResource> resources = new HashSet<IResource>(length);
        for (int i = 0; i < length; ++i) {
            IResource resource = (IResource)elements[i].getAdapter(class$org$eclipse$core$resources$IResource == null ? TextSearchScope.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource);
            if (resource == null) continue;
            resources.add(resource);
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    private static IAdaptable[] getElements(IWorkingSet[] workingSets) {
        int length = workingSets.length;
        HashSet<IAdaptable> elements = new HashSet<IAdaptable>(length);
        for (int i = 0; i < length; ++i) {
            elements.addAll(Arrays.asList(workingSets[i].getElements()));
        }
        return elements.toArray(new IAdaptable[elements.size()]);
    }

    public void addExtension(String extension) {
        Pattern pattern = Pattern.compile(this.asRegEx(extension), 66);
        this.fExtensions.add(pattern.matcher(""));
    }

    private String asRegEx(String pattern) {
        StringBuffer out = new StringBuffer(pattern.length());
        boolean escaped = false;
        boolean quoting = false;
        int i = 0;
        while (i < pattern.length()) {
            char ch;
            if ((ch = pattern.charAt(i++)) == '*' && !escaped) {
                if (quoting) {
                    out.append("\\E");
                    quoting = false;
                }
                out.append(".*");
                escaped = false;
                continue;
            }
            if (ch == '?' && !escaped) {
                if (quoting) {
                    out.append("\\E");
                    quoting = false;
                }
                out.append(".");
                escaped = false;
                continue;
            }
            if (ch == '\\' && !escaped) {
                escaped = true;
                continue;
            }
            if (ch == '\\' && escaped) {
                escaped = false;
                if (quoting) {
                    out.append("\\E");
                    quoting = false;
                }
                out.append("\\\\");
                continue;
            }
            if (!quoting) {
                out.append("\\Q");
                quoting = true;
            }
            if (escaped && ch != '*' && ch != '?' && ch != '\\') {
                out.append('\\');
            }
            out.append(ch);
            escaped = ch == '\\';
        }
        if (quoting) {
            out.append("\\E");
        }
        return out.toString();
    }

    public void addExtensions(Set extensions) {
        if (extensions == null) {
            return;
        }
        Iterator iter = extensions.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof String)) continue;
            this.addExtension((String)obj);
        }
    }

    public boolean encloses(IResourceProxy proxy) {
        if (proxy.getType() == 1 && this.skipFile(proxy)) {
            return false;
        }
        return super.encloses(proxy);
    }

    boolean skipFile(IResourceProxy proxy) {
        if (proxy != null) {
            Iterator iter = this.fExtensions.iterator();
            while (iter.hasNext()) {
                if (!((Matcher)iter.next()).reset(proxy.getName()).matches()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean encloses(IResource element) {
        if (element.getType() == 1 && this.skipFile((IFile)element)) {
            return false;
        }
        return super.encloses(element);
    }

    boolean skipFile(IFile file) {
        if (file != null) {
            Iterator iter = this.fExtensions.iterator();
            while (iter.hasNext()) {
                if (!((Matcher)iter.next()).reset(file.getName()).matches()) continue;
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class WorkspaceScope
    extends TextSearchScope {
        private WorkspaceScope() {
            super(SearchMessages.getString("WorkspaceScope"));
        }

        public void add(IResource element) {
        }

        public boolean encloses(IResourceProxy proxy) {
            return proxy.getType() != 1 || !this.skipFile(proxy);
        }
    }
}

