/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.text.CollationKey;
import java.text.Collator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.views.markers.internal.Util;

public class ConcreteMarker {
    private String description;
    private String resourceName;
    private String inFolder;
    private CollationKey descriptionKey;
    private CollationKey resourceNameKey;
    private CollationKey inFolderKey;
    private int line;
    private long creationTime;
    private String type;
    private IMarker marker;

    public ConcreteMarker(IMarker toCopy) {
        this.marker = toCopy;
        this.refresh();
    }

    public void clearCache() {
        this.resourceNameKey = null;
        this.descriptionKey = null;
        this.inFolderKey = null;
    }

    public void refresh() {
        this.clearCache();
        this.description = Util.getProperty("message", this.marker);
        this.resourceName = this.marker.getResource().getName();
        this.inFolder = Util.getContainerName(this.marker);
        this.line = this.marker.getAttribute("lineNumber", -1);
        try {
            this.creationTime = this.marker.getCreationTime();
        }
        catch (CoreException e) {
            this.creationTime = 0L;
        }
        try {
            this.type = this.marker.getType();
        }
        catch (CoreException e1) {
            this.type = "";
        }
    }

    public IResource getResource() {
        return this.marker.getResource();
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public CollationKey getDescriptionKey() {
        if (this.descriptionKey == null) {
            this.descriptionKey = Collator.getInstance().getCollationKey(this.description);
        }
        return this.descriptionKey;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public CollationKey getResourceNameKey() {
        if (this.resourceNameKey == null) {
            this.resourceNameKey = Collator.getInstance().getCollationKey(this.resourceName);
        }
        return this.resourceNameKey;
    }

    public int getLine() {
        return this.line;
    }

    public String getFolder() {
        return this.inFolder;
    }

    public CollationKey getFolderKey() {
        if (this.inFolderKey == null) {
            this.inFolderKey = Collator.getInstance().getCollationKey(this.inFolder);
        }
        return this.inFolderKey;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public IMarker getMarker() {
        return this.marker;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConcreteMarker)) {
            return false;
        }
        ConcreteMarker other = (ConcreteMarker)object;
        return other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        return this.getMarker().hashCode();
    }
}

