/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.datatransfer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.Javac;
import org.eclipse.ant.internal.ui.datatransfer.DataTransferMessages;
import org.eclipse.ant.internal.ui.datatransfer.ProjectCreator;
import org.eclipse.ant.internal.ui.editor.model.AntElementNode;
import org.eclipse.ant.internal.ui.editor.model.AntProjectNode;
import org.eclipse.ant.internal.ui.editor.model.AntTargetNode;
import org.eclipse.ant.internal.ui.editor.model.AntTaskNode;
import org.eclipse.ant.internal.ui.editor.outline.AntModel;
import org.eclipse.ant.internal.ui.editor.outline.LocationProvider;
import org.eclipse.ant.internal.ui.editor.outline.XMLCore;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class ExternalAntBuildfileImportPage
extends WizardPage {
    private Text projectNameField;
    private Text locationPathField;
    private Button browseButton;
    private AntModel fAntModel;
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event e) {
            ExternalAntBuildfileImportPage.this.fAntModel = ExternalAntBuildfileImportPage.this.getAntModel(ExternalAntBuildfileImportPage.this.getBuildFile(ExternalAntBuildfileImportPage.this.getProjectLocationFieldValue()));
            ExternalAntBuildfileImportPage.this.setProjectName();
            ExternalAntBuildfileImportPage.this.setPageComplete(ExternalAntBuildfileImportPage.this.validatePage());
        }
    };
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            ExternalAntBuildfileImportPage.this.setPageComplete(ExternalAntBuildfileImportPage.this.validatePage());
        }
    };
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public ExternalAntBuildfileImportPage() {
        super("externalAntBuildfilePage");
        this.setPageComplete(false);
        this.setTitle(DataTransferMessages.getString("ExternalAntBuildfileImportPage.9"));
        this.setDescription(DataTransferMessages.getString("ExternalAntBuildfileImportPage.10"));
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.ui.ide.new_project_wizard_page_context");
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createProjectNameGroup(composite);
        this.createProjectLocationGroup(composite);
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    private final void createProjectLocationGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        projectGroup.setFont(parent.getFont());
        Label projectContentsLabel = new Label(projectGroup, 0);
        projectContentsLabel.setText(DataTransferMessages.getString("ExternalAntBuildfileImportPage.11"));
        projectContentsLabel.setFont(parent.getFont());
        this.createUserSpecifiedProjectLocationGroup(projectGroup);
    }

    private final void createProjectNameGroup(Composite parent) {
        Font dialogFont = parent.getFont();
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setFont(dialogFont);
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(DataTransferMessages.getString("ExternalAntBuildfileImportPage.12"));
        projectLabel.setFont(dialogFont);
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(dialogFont);
        this.projectNameField.addListener(24, this.nameModifyListener);
    }

    private void createUserSpecifiedProjectLocationGroup(Composite projectGroup) {
        Font dialogFont = projectGroup.getFont();
        this.locationPathField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setFont(dialogFont);
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setText(DataTransferMessages.getString("ExternalAntBuildfileImportPage.13"));
        this.browseButton.setFont(dialogFont);
        this.setButtonLayoutData(this.browseButton);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExternalAntBuildfileImportPage.this.handleBrowseButtonPressed();
            }
        });
        this.locationPathField.addListener(24, this.locationModifyListener);
    }

    private String getProjectName(AntProjectNode projectNode) {
        String userSpecifiedName = this.getProjectNameFieldValue();
        if (userSpecifiedName.length() > 0) {
            return userSpecifiedName;
        }
        String projectName = projectNode.getLabel();
        if (projectName == null) {
            projectName = DataTransferMessages.getString("ExternalAntBuildfileImportPage.14");
        }
        return projectName;
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    private String getProjectLocationFieldValue() {
        return this.locationPathField.getText().trim();
    }

    private void handleBrowseButtonPressed() {
        String lastUsedPath = null;
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        FileDialog dialog = new FileDialog(this.getShell(), 4);
        dialog.setFilterExtensions(new String[]{"*.xml"});
        dialog.setFilterPath(lastUsedPath);
        String result = dialog.open();
        if (result == null) {
            return;
        }
        Path filterPath = new Path(dialog.getFilterPath());
        String buildFileName = dialog.getFileName();
        IPath path = filterPath.append(buildFileName).makeAbsolute();
        this.locationPathField.setText(path.toOSString());
    }

    private boolean validatePage() {
        String locationFieldContents = this.getProjectLocationFieldValue();
        if (locationFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(DataTransferMessages.getString("ExternalAntBuildfileImportPage.15"));
            return false;
        }
        Path path = new Path("");
        if (!path.isValidPath(locationFieldContents)) {
            this.setErrorMessage(DataTransferMessages.getString("ExternalAntBuildfileImportPage.16"));
            return false;
        }
        if (this.fAntModel == null) {
            this.setErrorMessage(DataTransferMessages.getString("ExternalAntBuildfileImportPage.17"));
            return false;
        }
        if (this.getProjectNameFieldValue().length() == 0) {
            this.setErrorMessage(DataTransferMessages.getString("ExternalAntBuildfileImportPage.18"));
            return false;
        }
        IProject existingProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectNameFieldValue());
        if (existingProject.exists()) {
            this.setErrorMessage(DataTransferMessages.getString("ExternalAntBuildfileImportPage.19"));
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    private void setProjectName() {
        if (this.fAntModel == null) {
            return;
        }
        AntProjectNode node = this.fAntModel.getProjectNode();
        String projectName = this.getProjectName(node);
        this.projectNameField.setText(projectName);
    }

    private File getBuildFile(String locationFieldContents) {
        File buildFile = new File(locationFieldContents);
        if (!buildFile.isFile() && buildFile.exists()) {
            return null;
        }
        return buildFile;
    }

    protected IJavaProject createProject() {
        IJavaProject[] result;
        block4: {
            AntProjectNode projectNode = this.fAntModel.getProjectNode();
            final ArrayList javacNodes = new ArrayList();
            this.getJavacNodes(javacNodes, projectNode);
            result = new IJavaProject[1];
            final String projectName = this.getProjectNameFieldValue();
            final File buildFile = this.getBuildFile(this.getProjectLocationFieldValue());
            if (javacNodes.size() > 1) {
                this.setErrorMessage(DataTransferMessages.getString("ExternalAntBuildfileImportPage.20"));
                return null;
            }
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    List javacTasks = ExternalAntBuildfileImportPage.this.resolveJavacTasks(javacNodes);
                    ProjectCreator creator = new ProjectCreator();
                    Iterator iter = javacTasks.iterator();
                    while (iter.hasNext()) {
                        Javac javacTask = (Javac)iter.next();
                        IJavaProject javaProject = creator.createJavaProjectFromJavacNode(projectName, javacTask);
                        ExternalAntBuildfileImportPage.this.importBuildFile(monitor, javaProject.getPath(), buildFile);
                        result[0] = javaProject;
                    }
                }
            };
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException e) {
                return null;
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (!(t instanceof CoreException)) break block4;
                ErrorDialog.openError((Shell)this.getShell(), (String)DataTransferMessages.getString("ExternalAntBuildfileImportPage.21"), null, (IStatus)((CoreException)t).getStatus());
            }
        }
        return result[0];
    }

    protected void importBuildFile(IProgressMonitor monitor, IPath destPath, File buildFile) {
        block3: {
            FileSystemStructureProvider structureProvider = FileSystemStructureProvider.INSTANCE;
            ArrayList<File> files = new ArrayList<File>(1);
            files.add(buildFile);
            File rootDir = buildFile.getParentFile();
            try {
                ImportOperation op = new ImportOperation(destPath, (Object)rootDir, (IImportStructureProvider)structureProvider, (IOverwriteQuery)new ImportOverwriteQuery(), files);
                op.setCreateContainerStructure(false);
                op.run(monitor);
            }
            catch (InterruptedException e) {
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (!(t instanceof CoreException)) break block3;
                ErrorDialog.openError((Shell)this.getShell(), (String)DataTransferMessages.getString("ExternalAntBuildfileImportPage.22"), null, (IStatus)((CoreException)t).getStatus());
            }
        }
    }

    private List resolveJavacTasks(List javacNodes) {
        ArrayList<Object> resolvedJavacTasks = new ArrayList<Object>(javacNodes.size());
        Iterator nodes = javacNodes.iterator();
        while (nodes.hasNext()) {
            AntTaskNode taskNode = (AntTaskNode)nodes.next();
            Task javacTask = taskNode.getTask();
            if (javacTask instanceof UnknownElement) {
                if (((UnknownElement)javacTask).getRealThing() == null) {
                    javacTask.maybeConfigure();
                }
                resolvedJavacTasks.add(((UnknownElement)javacTask).getRealThing());
                continue;
            }
            resolvedJavacTasks.add(javacTask);
        }
        return resolvedJavacTasks;
    }

    private AntModel getAntModel(final File buildFile) {
        IDocument doc = this.getDocument(buildFile);
        if (doc == null) {
            return null;
        }
        AntModel model = new AntModel(XMLCore.getDefault(), doc, null, new LocationProvider(null){

            public IPath getLocation() {
                return new Path(buildFile.getAbsolutePath());
            }
        });
        model.reconcile(null);
        return model;
    }

    private IDocument getDocument(File buildFile) {
        FileInputStream in;
        try {
            in = new FileInputStream(buildFile);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        String initialContent = this.getStreamContentAsString(in);
        return new Document(initialContent);
    }

    private String getStreamContentAsString(InputStream inputStream) {
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(inputStream, ResourcesPlugin.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            AntUIPlugin.log(e);
            return "";
        }
        return this.getReaderContentAsString(new BufferedReader(reader));
    }

    private String getReaderContentAsString(BufferedReader bufferedReader) {
        StringBuffer result = new StringBuffer();
        try {
            String line = bufferedReader.readLine();
            while (line != null) {
                if (result.length() != 0) {
                    result.append("\n");
                }
                result.append(line);
                line = bufferedReader.readLine();
            }
        }
        catch (IOException e) {
            AntUIPlugin.log(e);
            return null;
        }
        return result.toString();
    }

    private void getJavacNodes(List javacNodes, AntElementNode parent) {
        if (!parent.hasChildren()) {
            return;
        }
        List children = parent.getChildNodes();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            AntTaskNode task;
            AntElementNode node = (AntElementNode)iter.next();
            if (node instanceof AntTargetNode) {
                this.getJavacNodes(javacNodes, node);
                continue;
            }
            if (!(node instanceof AntTaskNode) || (task = (AntTaskNode)node).getName() != "javac") continue;
            javacNodes.add(task);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.locationPathField.setFocus();
        }
    }

    private static class ImportOverwriteQuery
    implements IOverwriteQuery {
        private ImportOverwriteQuery() {
        }

        public String queryOverwrite(String file) {
            return "ALL";
        }
    }
}

