/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.formatter;

import java.util.LinkedList;
import org.eclipse.ant.internal.ui.editor.formatter.FormattingPreferences;
import org.eclipse.ant.internal.ui.editor.formatter.XmlTagFormatter;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;

public class XmlElementFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final FormattingPreferences prefs;
    private final LinkedList fDocuments = new LinkedList();
    private final LinkedList fPartitions = new LinkedList();

    public XmlElementFormattingStrategy() {
        this.prefs = new FormattingPreferences();
    }

    public XmlElementFormattingStrategy(FormattingPreferences prefs) {
        Assert.isNotNull((Object)prefs);
        this.prefs = prefs;
    }

    public void format() {
        super.format();
        IDocument document = (IDocument)this.fDocuments.removeFirst();
        TypedPosition partition = (TypedPosition)this.fPartitions.removeFirst();
        if (document == null || partition == null) {
            return;
        }
        try {
            String formatted = this.formatElement(document, partition);
            String partitionText = document.get(partition.getOffset(), partition.getLength());
            if (formatted != null && !formatted.equals(partitionText)) {
                document.replace(partition.getOffset(), partition.getLength(), formatted);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private String formatElement(IDocument document, TypedPosition partition) throws BadLocationException {
        String partitionText = document.get(partition.getOffset(), partition.getLength());
        IRegion line = document.getLineInformationOfOffset(partition.getOffset());
        int indentLength = partition.getOffset() - line.getOffset();
        return XmlTagFormatter.format(partitionText, this.prefs, document.get(line.getOffset(), indentLength));
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        this.fPartitions.addLast(context.getProperty((Object)"formatting.context.partition"));
        this.fDocuments.addLast(context.getProperty((Object)"formatting.context.medium"));
    }

    public void formatterStops() {
        super.formatterStops();
        this.fPartitions.clear();
        this.fDocuments.clear();
    }
}

