/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Locale;
import org.eclipse.core.internal.boot.PlatformURLBaseConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.registry.EclipseBundleListener;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.RegistryCacheReader;
import org.eclipse.core.internal.registry.RegistryCacheWriter;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.PlatformURLFragmentConnection;
import org.eclipse.core.internal.runtime.PlatformURLPluginConnection;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.FileManager;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.service.runnable.ParameterizedRunnable;
import org.eclipse.osgi.service.systembundle.EntryLocator;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;

public class PlatformActivator
extends Plugin
implements BundleActivator {
    private static final String PROP_ECLIPSE_EXITCODE = "eclipse.exitcode";
    private static final String PROP_ECLIPSE_APPLICATION = "eclipse.application";
    private static final String NL_SYSTEM_BUNDLE = "org.eclipse.osgi.nl";
    private static final String NL_PROP_EXT = ".properties";
    private static BundleContext context;
    private EclipseBundleListener pluginBundleListener;
    private ServiceReference environmentServiceReference;
    private ServiceReference urlServiceReference;
    private ServiceReference logServiceReference;
    private ServiceReference packageAdminReference;
    private ServiceRegistration entryLocatorRegistration;
    private long registryStamp;
    static /* synthetic */ Class class$org$osgi$service$url$URLStreamHandlerService;
    static /* synthetic */ Class class$org$eclipse$core$runtime$IExtensionRegistry;
    static /* synthetic */ Class class$org$eclipse$osgi$service$environment$EnvironmentInfo;
    static /* synthetic */ Class class$org$eclipse$osgi$service$urlconversion$URLConverter;
    static /* synthetic */ Class class$org$eclipse$osgi$framework$log$FrameworkLog;
    static /* synthetic */ Class class$org$osgi$service$packageadmin$PackageAdmin;
    static /* synthetic */ Class class$org$eclipse$osgi$service$runnable$ParameterizedRunnable;
    static /* synthetic */ Class class$org$eclipse$osgi$service$systembundle$EntryLocator;

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext runtimeContext) throws Exception {
        context = runtimeContext;
        this.acquireInfoService();
        this.acquireURLConverterService();
        this.acquireFrameworkLogService();
        this.acquirePackageAdminService();
        this.registerEntryLocator();
        this.startInternalPlatform();
        this.startRegistry(runtimeContext);
        this.installPlatformURLSupport();
        this.registerApplicationService();
        InternalPlatform.getDefault().setRuntimeInstance(this);
        super.start(runtimeContext);
    }

    private void installPlatformURLSupport() {
        PlatformURLPluginConnection.startup();
        PlatformURLFragmentConnection.startup();
        PlatformURLBaseConnection.startup(InternalPlatform.getDefault().getInstallURL());
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>(1);
        properties.put("url.handler.protocol", new String[]{"platform"});
        context.registerService((class$org$osgi$service$url$URLStreamHandlerService == null ? (class$org$osgi$service$url$URLStreamHandlerService = PlatformActivator.class$("org.osgi.service.url.URLStreamHandlerService")) : class$org$osgi$service$url$URLStreamHandlerService).getName(), (Object)new PlatformURLHandler(), properties);
    }

    private void startRegistry(BundleContext runtimeContext) {
        boolean fromCache = true;
        ExtensionRegistry registry = null;
        if (!"true".equals(System.getProperty("eclipse.noRegistryCache"))) {
            MultiStatus problems = new MultiStatus("org.eclipse.core.runtime", 1, "Registry cache problems", null);
            long start = 0L;
            if (InternalPlatform.DEBUG) {
                start = System.currentTimeMillis();
            }
            boolean lazyLoading = !"true".equals(System.getProperty("eclipse.noLazyRegistryCacheLoading"));
            File cacheFile = null;
            try {
                cacheFile = InternalPlatform.getDefault().getRuntimeFileManager().lookup(".registry", false);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (cacheFile == null || !cacheFile.isFile()) {
                Location currentLocation = Platform.getConfigurationLocation();
                Location parentLocation = null;
                if (currentLocation != null && (parentLocation = currentLocation.getParentLocation()) != null) {
                    try {
                        FileManager fileManagerShared = new FileManager(new File(parentLocation.getURL().getFile() + '/' + "org.eclipse.core.runtime"), "none");
                        fileManagerShared.open(false);
                        cacheFile = fileManagerShared.lookup(".registry", false);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            if (cacheFile != null && cacheFile.isFile()) {
                this.registryStamp = this.computeRegistryStamp();
                boolean flushable = !"true".equals(System.getProperty("eclipse.noRegistryFlushing"));
                registry = new RegistryCacheReader(cacheFile, problems, lazyLoading, flushable).loadCache(this.registryStamp);
            }
            if (InternalPlatform.DEBUG && registry != null) {
                System.out.println("Reading registry cache: " + (System.currentTimeMillis() - start));
            }
            if (InternalPlatform.DEBUG_REGISTRY) {
                if (registry == null) {
                    System.out.println("Reloading registry from manifest files...");
                } else {
                    System.out.println("Using registry cache " + (lazyLoading ? "with" : "without") + " lazy element loading...");
                }
            }
            if (!problems.isOK()) {
                System.out.println(problems);
            }
        }
        if (registry == null) {
            fromCache = false;
            registry = new ExtensionRegistry();
        }
        InternalPlatform.getDefault().setExtensionRegistry(registry);
        this.pluginBundleListener = new EclipseBundleListener(registry);
        runtimeContext.addBundleListener((BundleListener)this.pluginBundleListener);
        if (!fromCache) {
            this.pluginBundleListener.processBundles(runtimeContext.getBundles());
        }
        runtimeContext.registerService((class$org$eclipse$core$runtime$IExtensionRegistry == null ? (class$org$eclipse$core$runtime$IExtensionRegistry = PlatformActivator.class$("org.eclipse.core.runtime.IExtensionRegistry")) : class$org$eclipse$core$runtime$IExtensionRegistry).getName(), (Object)registry, new Hashtable());
    }

    private long computeRegistryStamp() {
        if (!"true".equalsIgnoreCase(System.getProperty("osgi.checkConfiguration"))) {
            return 0L;
        }
        Bundle[] allBundles = context.getBundles();
        long result = 0L;
        for (int i = 0; i < allBundles.length; ++i) {
            URL pluginManifest = allBundles[i].getEntry("plugin.xml");
            if (pluginManifest == null) {
                pluginManifest = allBundles[i].getEntry("fragment.xml");
            }
            if (pluginManifest == null) continue;
            try {
                URLConnection connection = pluginManifest.openConnection();
                result ^= connection.getLastModified() + allBundles[i].getBundleId();
                continue;
            }
            catch (IOException e) {
                return 0L;
            }
        }
        return result;
    }

    public void stop(BundleContext runtimeContext) throws IOException {
        this.stopRegistry(runtimeContext);
        this.unregisterEntryLocator();
        this.environmentInfoServiceReleased(this.environmentServiceReference);
        this.urlServiceReleased(this.urlServiceReference);
        this.logServiceReleased(this.logServiceReference);
        this.packageAdminServiceReleased(this.packageAdminReference);
        InternalPlatform.getDefault().stop(runtimeContext);
        InternalPlatform.getDefault().setRuntimeInstance(null);
        InternalPlatform.getDefault().getRuntimeFileManager().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopRegistry(BundleContext runtimeContext) {
        runtimeContext.removeBundleListener((BundleListener)this.pluginBundleListener);
        ExtensionRegistry registry = (ExtensionRegistry)InternalPlatform.getDefault().getRegistry();
        if (registry == null) {
            return;
        }
        try {
            if (!registry.isDirty()) {
                return;
            }
            FileManager manager = InternalPlatform.getDefault().getRuntimeFileManager();
            File cacheFile = null;
            try {
                manager.lookup(".registry", true);
                cacheFile = File.createTempFile("registry", ".new", manager.getBase());
            }
            catch (IOException e) {
                InternalPlatform.getDefault().setExtensionRegistry(null);
                return;
            }
            new RegistryCacheWriter(cacheFile).saveCache(registry, this.computeRegistryStamp());
            try {
                manager.update(new String[]{".registry"}, new String[]{cacheFile.getName()});
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        finally {
            InternalPlatform.getDefault().setExtensionRegistry(null);
        }
    }

    private void acquireInfoService() throws Exception {
        this.environmentServiceReference = context.getServiceReference((class$org$eclipse$osgi$service$environment$EnvironmentInfo == null ? (class$org$eclipse$osgi$service$environment$EnvironmentInfo = PlatformActivator.class$("org.eclipse.osgi.service.environment.EnvironmentInfo")) : class$org$eclipse$osgi$service$environment$EnvironmentInfo).getName());
        if (this.environmentServiceReference == null) {
            return;
        }
        InternalPlatform.infoService = (EnvironmentInfo)context.getService(this.environmentServiceReference);
    }

    private void acquireURLConverterService() throws Exception {
        this.urlServiceReference = context.getServiceReference((class$org$eclipse$osgi$service$urlconversion$URLConverter == null ? (class$org$eclipse$osgi$service$urlconversion$URLConverter = PlatformActivator.class$("org.eclipse.osgi.service.urlconversion.URLConverter")) : class$org$eclipse$osgi$service$urlconversion$URLConverter).getName());
        if (this.urlServiceReference == null) {
            return;
        }
        InternalPlatform.urlConverter = (URLConverter)context.getService(this.urlServiceReference);
    }

    private void acquireFrameworkLogService() throws Exception {
        this.logServiceReference = context.getServiceReference((class$org$eclipse$osgi$framework$log$FrameworkLog == null ? (class$org$eclipse$osgi$framework$log$FrameworkLog = PlatformActivator.class$("org.eclipse.osgi.framework.log.FrameworkLog")) : class$org$eclipse$osgi$framework$log$FrameworkLog).getName());
        if (this.logServiceReference == null) {
            return;
        }
        InternalPlatform.frameworkLog = (FrameworkLog)context.getService(this.logServiceReference);
    }

    private void acquirePackageAdminService() throws Exception {
        this.packageAdminReference = context.getServiceReference((class$org$osgi$service$packageadmin$PackageAdmin == null ? (class$org$osgi$service$packageadmin$PackageAdmin = PlatformActivator.class$("org.osgi.service.packageadmin.PackageAdmin")) : class$org$osgi$service$packageadmin$PackageAdmin).getName());
        if (this.packageAdminReference == null) {
            return;
        }
        InternalPlatform.packageAdmin = (PackageAdmin)context.getService(this.packageAdminReference);
    }

    private void startInternalPlatform() throws IOException {
        InternalPlatform.getDefault().start(context);
    }

    private void environmentInfoServiceReleased(ServiceReference reference) {
        if (this.environmentServiceReference == null) {
            return;
        }
        if (this.environmentServiceReference != reference) {
            return;
        }
        InternalPlatform.infoService = null;
        context.ungetService(this.environmentServiceReference);
        this.environmentServiceReference = null;
    }

    private void urlServiceReleased(ServiceReference reference) {
        if (this.urlServiceReference == null) {
            return;
        }
        if (this.urlServiceReference != reference) {
            return;
        }
        InternalPlatform.urlConverter = null;
        context.ungetService(this.urlServiceReference);
        this.urlServiceReference = null;
    }

    private void logServiceReleased(ServiceReference reference) {
        if (this.logServiceReference == null) {
            return;
        }
        if (this.logServiceReference != reference) {
            return;
        }
        InternalPlatform.frameworkLog = null;
        context.ungetService(this.logServiceReference);
        this.logServiceReference = null;
    }

    private void packageAdminServiceReleased(ServiceReference reference) {
        if (this.packageAdminReference == null) {
            return;
        }
        if (this.packageAdminReference != reference) {
            return;
        }
        InternalPlatform.packageAdmin = null;
        context.ungetService(this.packageAdminReference);
        this.packageAdminReference = null;
    }

    private void registerApplicationService() {
        ParameterizedRunnable work = new ParameterizedRunnable(){

            public Object run(Object arg) throws Exception {
                Object result;
                IProduct product;
                IPlatformRunnable application = null;
                String applicationId = System.getProperty(PlatformActivator.PROP_ECLIPSE_APPLICATION);
                if (applicationId == null && (product = InternalPlatform.getDefault().getProduct()) != null && (applicationId = product.getApplication()) != null) {
                    System.setProperty(PlatformActivator.PROP_ECLIPSE_APPLICATION, applicationId);
                }
                if (applicationId == null) {
                    throw new RuntimeException(Policy.bind("application.noIdFound"));
                }
                IExtensionRegistry registry = InternalPlatform.getDefault().getRegistry();
                IExtension applicationExtension = registry.getExtension("org.eclipse.core.runtime", "applications", applicationId);
                if (applicationExtension == null) {
                    IExtension[] availableApps = registry.getExtensionPoint("org.eclipse.core.runtime.applications").getExtensions();
                    String availableAppsString = "<NONE>";
                    if (availableApps.length != 0) {
                        availableAppsString = availableApps[0].getUniqueIdentifier();
                        for (int i = 1; i < availableApps.length; ++i) {
                            availableAppsString = availableAppsString + ", " + availableApps[i].getUniqueIdentifier();
                        }
                    }
                    throw new RuntimeException(Policy.bind("application.notFound", applicationId, availableAppsString));
                }
                IConfigurationElement[] configs = applicationExtension.getConfigurationElements();
                if (configs.length == 0) {
                    throw new RuntimeException(Policy.bind("application.invalidExtension", applicationId));
                }
                IConfigurationElement config = configs[0];
                application = (IPlatformRunnable)config.createExecutableExtension("run");
                if (arg == null) {
                    arg = InternalPlatform.getDefault().getApplicationArgs();
                }
                int exitCode = (result = application.run(arg)) instanceof Integer ? (Integer)result : 0;
                System.setProperty(PlatformActivator.PROP_ECLIPSE_EXITCODE, Integer.toString(exitCode));
                if (InternalPlatform.DEBUG) {
                    System.out.println(Policy.bind("application.returned", new String[]{applicationId, result == null ? "null" : result.toString()}));
                }
                return result;
            }
        };
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        properties.put(PROP_ECLIPSE_APPLICATION, "default");
        context.registerService((class$org$eclipse$osgi$service$runnable$ParameterizedRunnable == null ? (class$org$eclipse$osgi$service$runnable$ParameterizedRunnable = PlatformActivator.class$("org.eclipse.osgi.service.runnable.ParameterizedRunnable")) : class$org$eclipse$osgi$service$runnable$ParameterizedRunnable).getName(), (Object)work, properties);
    }

    private void registerEntryLocator() {
        EntryLocator systemResources = new EntryLocator(){

            public URL getProperties(String basename, Locale locale) {
                basename = basename.replace('.', '/');
                Path propertiesPath = new Path("org.eclipse.osgi.nl/" + basename + '_' + locale.getLanguage() + '_' + locale.getCountry() + PlatformActivator.NL_PROP_EXT);
                URL result = Platform.find(context.getBundle(), propertiesPath);
                if (result != null) {
                    return result;
                }
                propertiesPath = new Path("org.eclipse.osgi.nl/" + basename + '_' + locale.getLanguage() + PlatformActivator.NL_PROP_EXT);
                return Platform.find(context.getBundle(), propertiesPath);
            }
        };
        this.entryLocatorRegistration = context.registerService((class$org$eclipse$osgi$service$systembundle$EntryLocator == null ? (class$org$eclipse$osgi$service$systembundle$EntryLocator = PlatformActivator.class$("org.eclipse.osgi.service.systembundle.EntryLocator")) : class$org$eclipse$osgi$service$systembundle$EntryLocator).getName(), (Object)systemResources, null);
    }

    private void unregisterEntryLocator() {
        if (this.entryLocatorRegistration != null) {
            this.entryLocatorRegistration.unregister();
            this.entryLocatorRegistration = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

