/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Field;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Method;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdi.hcr.ThreadReference;
import org.eclipse.jdi.hcr.VirtualMachine;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugElement;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIFieldVariable;
import org.eclipse.jdt.internal.debug.core.model.JDILocalVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIThisVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.core.model.JDIType;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;

public class JDIStackFrame
extends JDIDebugElement
implements IJavaStackFrame {
    private int fDepth;
    private StackFrame fStackFrame;
    private Method fLastMethod;
    private JDIThread fThread;
    private List fVariables;
    private Method fMethod = null;
    private ObjectReference fThisObject;
    private String fDeclaringTypeName;
    private String fReceivingTypeName;
    private boolean fRefreshVariables = true;
    private boolean fIsOutOfSynch = false;
    private String fSourceName;
    private boolean fLocalsAvailable = true;
    static /* synthetic */ Class class$org$eclipse$jdt$debug$core$IJavaStackFrame;
    static /* synthetic */ Class class$org$eclipse$jdt$debug$core$IJavaModifiers;

    public JDIStackFrame(JDIThread thread, int depth) {
        super((JDIDebugTarget)thread.getDebugTarget());
        this.setDepth(depth);
        this.setThread(thread);
    }

    protected void setDepth(int depth) {
        this.fDepth = depth;
        this.clearCachedData();
        this.fRefreshVariables = true;
    }

    protected int getDepth() {
        return this.fDepth;
    }

    public IThread getThread() {
        return this.fThread;
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean canStepInto() {
        try {
            return this.exists() && this.isTopStackFrame() && !this.isObsolete() && this.getThread().canStepInto();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
            return false;
        }
    }

    public boolean canStepOver() {
        try {
            return this.exists() && !this.isObsolete() && this.getThread().canStepOver();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
            return false;
        }
    }

    public boolean canStepReturn() {
        try {
            if (!this.exists() || this.isObsolete() || !this.getThread().canStepReturn()) {
                return false;
            }
            List frames = ((JDIThread)this.getThread()).computeStackFrames();
            if (frames != null && !frames.isEmpty()) {
                int index;
                boolean bottomFrame = this.equals(frames.get(frames.size() - 1));
                boolean aboveObsoleteFrame = false;
                if (!bottomFrame && (index = frames.indexOf(this)) < frames.size() - 1 && ((JDIStackFrame)frames.get(index + 1)).isObsolete()) {
                    aboveObsoleteFrame = true;
                }
                return !bottomFrame && !aboveObsoleteFrame;
            }
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getUnderlyingMethod() throws DebugException {
        JDIThread jDIThread = this.fThread;
        synchronized (jDIThread) {
            if (this.fStackFrame == null || this.fMethod == null) {
                try {
                    this.fLastMethod = this.fMethod = this.getUnderlyingStackFrame().location().method();
                }
                catch (RuntimeException e) {
                    this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIStackFrame.exception_retrieving_method"), e.toString()), e);
                }
            }
            return this.fMethod;
        }
    }

    public IVariable[] getVariables() throws DebugException {
        List list = this.getVariables0();
        return list.toArray(new IVariable[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getVariables0() throws DebugException {
        JDIThread jDIThread = this.fThread;
        synchronized (jDIThread) {
            if (this.fVariables == null) {
                if (this.isNative()) {
                    this.requestFailed(JDIDebugModelMessages.getString("JDIStackFrame.Variable_information_unavailable_for_native_methods"), null);
                }
                Method method = this.getUnderlyingMethod();
                this.fVariables = new ArrayList();
                if (method.isStatic()) {
                    List<Field> allFields = null;
                    ReferenceType declaringType = method.declaringType();
                    try {
                        allFields = declaringType.allFields();
                    }
                    catch (RuntimeException e) {
                        this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIStackFrame.exception_retrieving_fields"), e.toString()), e);
                        return Collections.EMPTY_LIST;
                    }
                    if (allFields != null) {
                        Iterator<Field> fields = allFields.iterator();
                        while (fields.hasNext()) {
                            Field field = fields.next();
                            if (!field.isStatic()) continue;
                            this.fVariables.add(new JDIFieldVariable((JDIDebugTarget)this.getDebugTarget(), field, declaringType));
                        }
                        Collections.sort(this.fVariables, new Comparator(){

                            public int compare(Object a, Object b) {
                                JDIFieldVariable v1 = (JDIFieldVariable)a;
                                JDIFieldVariable v2 = (JDIFieldVariable)b;
                                try {
                                    return v1.getName().compareToIgnoreCase(v2.getName());
                                }
                                catch (DebugException de) {
                                    JDIStackFrame.this.logError((Exception)((Object)de));
                                    return -1;
                                }
                            }
                        });
                    }
                } else {
                    ObjectReference t = this.getUnderlyingThisObject();
                    if (t != null) {
                        this.fVariables.add(new JDIThisVariable((JDIDebugTarget)this.getDebugTarget(), t));
                    }
                }
                Iterator variables = this.getUnderlyingVisibleVariables().iterator();
                while (variables.hasNext()) {
                    LocalVariable var = (LocalVariable)variables.next();
                    this.fVariables.add(new JDILocalVariable(this, var));
                }
            } else if (this.fRefreshVariables) {
                this.updateVariables();
            }
            this.fRefreshVariables = false;
            return this.fVariables;
        }
    }

    public String getName() throws DebugException {
        return this.getMethodName();
    }

    public List getArgumentTypeNames() throws DebugException {
        try {
            return this.getUnderlyingMethod().argumentTypeNames();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIStackFrame.exception_retrieving_argument_type_names"), e.toString()), e);
            return null;
        }
    }

    public int getLineNumber() throws DebugException {
        block3: {
            if (this.isSuspended()) {
                try {
                    return this.getUnderlyingStackFrame().location().lineNumber();
                }
                catch (RuntimeException e) {
                    if (!this.getThread().isSuspended()) break block3;
                    this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIStackFrame.exception_retrieving_line_number"), e.toString()), e);
                }
            }
        }
        return -1;
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void stepInto() throws DebugException {
        if (!this.canStepInto()) {
            return;
        }
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        if (!this.canStepOver()) {
            return;
        }
        if (this.isTopStackFrame()) {
            this.getThread().stepOver();
        } else {
            ((JDIThread)this.getThread()).stepToFrame(this);
        }
    }

    public void stepReturn() throws DebugException {
        if (!this.canStepReturn()) {
            return;
        }
        if (this.isTopStackFrame()) {
            this.getThread().stepReturn();
        } else {
            List frames = ((JDIThread)this.getThread()).computeStackFrames();
            int index = frames.indexOf(this);
            if (index >= 0 && index < frames.size() - 1) {
                IStackFrame nextFrame = (IStackFrame)frames.get(index + 1);
                ((JDIThread)this.getThread()).stepToFrame(nextFrame);
            }
        }
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    protected void updateVariables() throws DebugException {
        JDILocalVariable local;
        if (this.fVariables == null) {
            return;
        }
        Method method = this.getUnderlyingMethod();
        int index = 0;
        if (!method.isStatic()) {
            ObjectReference thisObject;
            try {
                thisObject = this.getUnderlyingThisObject();
            }
            catch (DebugException exception) {
                if (!this.getThread().isSuspended()) {
                    thisObject = null;
                }
                throw exception;
            }
            JDIThisVariable oldThisObject = null;
            if (!this.fVariables.isEmpty() && this.fVariables.get(0) instanceof JDIThisVariable) {
                oldThisObject = (JDIThisVariable)this.fVariables.get(0);
            }
            if (thisObject == null && oldThisObject != null) {
                this.fVariables.remove(0);
                index = 0;
            } else if (oldThisObject == null && thisObject != null) {
                oldThisObject = new JDIThisVariable((JDIDebugTarget)this.getDebugTarget(), thisObject);
                this.fVariables.add(0, oldThisObject);
                index = 1;
            } else if (oldThisObject != null) {
                if (!oldThisObject.retrieveValue().equals(thisObject)) {
                    this.fVariables.remove(0);
                    this.fVariables.add(0, new JDIThisVariable((JDIDebugTarget)this.getDebugTarget(), thisObject));
                }
                index = 1;
            }
        }
        List locals = null;
        try {
            locals = this.getUnderlyingStackFrame().visibleVariables();
        }
        catch (AbsentInformationException e) {
            locals = Collections.EMPTY_LIST;
        }
        catch (NativeMethodException e) {
            locals = Collections.EMPTY_LIST;
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIStackFrame.exception_retrieving_visible_variables"), e.toString()), e);
            return;
        }
        int localIndex = -1;
        while (index < this.fVariables.size()) {
            Object var = this.fVariables.get(index);
            if (var instanceof JDILocalVariable) {
                local = (JDILocalVariable)this.fVariables.get(index);
                localIndex = locals.indexOf(local.getLocal());
                if (localIndex >= 0) {
                    local.setLocal((LocalVariable)locals.get(localIndex));
                    locals.remove(localIndex);
                    ++index;
                    continue;
                }
                this.fVariables.remove(index);
                continue;
            }
            ++index;
        }
        Iterator newOnes = locals.iterator();
        while (newOnes.hasNext()) {
            local = new JDILocalVariable(this, (LocalVariable)newOnes.next());
            this.fVariables.add(local);
        }
    }

    public boolean supportsDropToFrame() {
        JDIThread thread = (JDIThread)this.getThread();
        JDIDebugTarget target = (JDIDebugTarget)thread.getDebugTarget();
        try {
            if (!target.isAvailable() || !thread.isSuspended() || thread.isTerminated()) {
                return false;
            }
            boolean j9Support = false;
            boolean jdkSupport = target.canPopFrames();
            com.sun.jdi.VirtualMachine vm = this.getVM();
            if (vm == null) {
                return false;
            }
            try {
                j9Support = thread.getUnderlyingThread() instanceof ThreadReference && ((VirtualMachine)((Object)vm)).canDoReturn();
            }
            catch (UnsupportedOperationException uoe) {
                j9Support = false;
            }
            if (jdkSupport || j9Support) {
                List frames = thread.computeStackFrames();
                if (jdkSupport && frames.size() > 0 && frames.get(frames.size() - 1) == this) {
                    return false;
                }
                JDIStackFrame frame = null;
                for (int index = 0; index < frames.size(); ++index) {
                    frame = (JDIStackFrame)frames.get(index);
                    if (!frame.isNative()) continue;
                    return false;
                }
            }
            return false;
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
        catch (RuntimeException e) {
            this.internalError(e);
        }
        return false;
    }

    public void dropToFrame() throws DebugException {
        if (this.supportsDropToFrame()) {
            ((JDIThread)this.getThread()).dropToFrame(this);
        } else {
            this.notSupported(JDIDebugModelMessages.getString("JDIStackFrame.Drop_to_frame_not_supported"));
        }
    }

    public void popFrame() throws DebugException {
        if (this.supportsDropToFrame()) {
            ((JDIThread)this.getThread()).popFrame(this);
        } else {
            this.notSupported(JDIDebugModelMessages.getString("JDIStackFrame.pop_frame_not_supported"));
        }
    }

    public IJavaVariable findVariable(String varName) throws DebugException {
        if (this.isNative()) {
            return null;
        }
        IVariable[] variables = this.getVariables();
        IJavaVariable thisVariable = null;
        for (int i = 0; i < variables.length; ++i) {
            IJavaVariable var = (IJavaVariable)variables[i];
            if (var.getName().equals(varName)) {
                return var;
            }
            if (!(var instanceof JDIThisVariable)) continue;
            thisVariable = var;
        }
        if (thisVariable != null) {
            IVariable[] thisChildren = thisVariable.getValue().getVariables();
            for (int i = 0; i < thisChildren.length; ++i) {
                IJavaVariable var = (IJavaVariable)thisChildren[i];
                if (!var.getName().equals(varName)) continue;
                return var;
            }
        }
        return null;
    }

    protected List getUnderlyingVisibleVariables() throws DebugException {
        List<LocalVariable> variables = Collections.EMPTY_LIST;
        try {
            variables = this.getUnderlyingStackFrame().visibleVariables();
        }
        catch (AbsentInformationException e) {
            this.setLocalsAvailable(false);
        }
        catch (NativeMethodException e) {
            this.setLocalsAvailable(false);
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIStackFrame.exception_retrieving_visible_variables_2"), e.toString()), e);
        }
        return variables;
    }

    protected ObjectReference getUnderlyingThisObject() throws DebugException {
        if (this.fStackFrame == null || this.fThisObject == null && !this.isStatic()) {
            try {
                this.fThisObject = this.getUnderlyingStackFrame().thisObject();
            }
            catch (RuntimeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIStackFrame.exception_retrieving_this"), e.toString()), e);
                return null;
            }
        }
        return this.fThisObject;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == (class$org$eclipse$jdt$debug$core$IJavaStackFrame == null ? (class$org$eclipse$jdt$debug$core$IJavaStackFrame = JDIStackFrame.class$("org.eclipse.jdt.debug.core.IJavaStackFrame")) : class$org$eclipse$jdt$debug$core$IJavaStackFrame) || adapter == (class$org$eclipse$jdt$debug$core$IJavaModifiers == null ? (class$org$eclipse$jdt$debug$core$IJavaModifiers = JDIStackFrame.class$("org.eclipse.jdt.debug.core.IJavaModifiers")) : class$org$eclipse$jdt$debug$core$IJavaModifiers)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public String getSignature() throws DebugException {
        try {
            return this.getUnderlyingMethod().signature();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIStackFrame.exception_retrieving_method_signature"), e.toString()), e);
            return null;
        }
    }

    public String getDeclaringTypeName() throws DebugException {
        if (this.fStackFrame == null || this.fDeclaringTypeName == null) {
            try {
                this.fDeclaringTypeName = this.isObsolete() ? JDIDebugModelMessages.getString("JDIStackFrame.<unknown_declaring_type>_1") : this.getUnderlyingMethod().declaringType().name();
            }
            catch (RuntimeException e) {
                if (this.getThread().isSuspended()) {
                    this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIStackFrame.exception_retrieving_declaring_type"), e.toString()), e);
                }
                return JDIDebugModelMessages.getString("JDIStackFrame.<unknown_declaring_type>_1");
            }
        }
        return this.fDeclaringTypeName;
    }

    public String getReceivingTypeName() throws DebugException {
        if (this.fStackFrame == null || this.fReceivingTypeName == null) {
            try {
                ObjectReference thisObject;
                this.fReceivingTypeName = this.isObsolete() ? JDIDebugModelMessages.getString("JDIStackFrame.<unknown_receiving_type>_2") : ((thisObject = this.getUnderlyingThisObject()) == null ? this.getDeclaringTypeName() : thisObject.referenceType().name());
            }
            catch (RuntimeException e) {
                if (this.getThread().isSuspended()) {
                    this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIStackFrame.exception_retrieving_receiving_type"), e.toString()), e);
                }
                return JDIDebugModelMessages.getString("JDIStackFrame.<unknown_receiving_type>_2");
            }
        }
        return this.fReceivingTypeName;
    }

    public String getMethodName() throws DebugException {
        try {
            return this.getUnderlyingMethod().name();
        }
        catch (RuntimeException e) {
            if (this.getThread().isSuspended()) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIStackFrame.exception_retrieving_method_name"), e.toString()), e);
            }
            return JDIDebugModelMessages.getString("JDIStackFrame.<unknown_method>_1");
        }
    }

    public boolean isNative() throws DebugException {
        return this.getUnderlyingMethod().isNative();
    }

    public boolean isConstructor() throws DebugException {
        return this.getUnderlyingMethod().isConstructor();
    }

    public boolean isStaticInitializer() throws DebugException {
        return this.getUnderlyingMethod().isStaticInitializer();
    }

    public boolean isFinal() throws DebugException {
        return this.getUnderlyingMethod().isFinal();
    }

    public boolean isSynchronized() throws DebugException {
        return this.getUnderlyingMethod().isSynchronized();
    }

    public boolean isSynthetic() throws DebugException {
        return this.getUnderlyingMethod().isSynthetic();
    }

    public boolean isPublic() throws DebugException {
        return this.getUnderlyingMethod().isPublic();
    }

    public boolean isPrivate() throws DebugException {
        return this.getUnderlyingMethod().isPrivate();
    }

    public boolean isProtected() throws DebugException {
        return this.getUnderlyingMethod().isProtected();
    }

    public boolean isPackagePrivate() throws DebugException {
        return this.getUnderlyingMethod().isPackagePrivate();
    }

    public boolean isStatic() throws DebugException {
        return this.getUnderlyingMethod().isStatic();
    }

    public String getSourceName() throws DebugException {
        if (this.fStackFrame == null || this.fSourceName == null) {
            try {
                this.fSourceName = this.getUnderlyingStackFrame().location().sourceName();
            }
            catch (AbsentInformationException e) {
                this.fSourceName = null;
            }
            catch (NativeMethodException e) {
                this.fSourceName = null;
            }
            catch (RuntimeException e) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIStackFrame.exception_retrieving_source_name"), e.toString()), e);
            }
        }
        return this.fSourceName;
    }

    protected boolean isTopStackFrame() throws DebugException {
        IStackFrame tos = this.getThread().getTopStackFrame();
        return tos != null && tos.equals(this);
    }

    public void setOutOfSynch(boolean outOfSynch) {
        this.fIsOutOfSynch = outOfSynch;
    }

    public boolean isOutOfSynch() throws DebugException {
        JDIDebugTarget target;
        if (this.fIsOutOfSynch) {
            return true;
        }
        return this.getThread().isSuspended() && (target = (JDIDebugTarget)this.getDebugTarget()).hasHCROccurred() && target.isOutOfSynch(this.getUnderlyingMethod().declaringType().name());
    }

    public boolean isObsolete() throws DebugException {
        if (!JDIDebugPlugin.isJdiVersionGreaterThanOrEqual(new int[]{1, 4}) || !((JDIDebugTarget)this.getDebugTarget()).hasHCROccurred()) {
            return false;
        }
        if (this.getThread().isSuspended()) {
            try {
                return this.getUnderlyingMethod().isObsolete();
            }
            catch (RuntimeException re) {
                this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIStackFrame.Exception_occurred_determining_if_stack_frame_is_obsolete_1"), re.toString()), re);
                return true;
            }
        }
        return false;
    }

    protected boolean exists() throws DebugException {
        return ((JDIThread)this.getThread()).computeStackFrames().indexOf(this) != -1;
    }

    public boolean canTerminate() {
        boolean exists = false;
        try {
            exists = this.exists();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
        return exists && this.getThread().canTerminate() || this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        if (this.getThread().canTerminate()) {
            this.getThread().terminate();
        } else {
            this.getDebugTarget().terminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StackFrame getUnderlyingStackFrame() throws DebugException {
        JDIThread jDIThread = this.fThread;
        synchronized (jDIThread) {
            if (this.fStackFrame == null) {
                int depth = this.getDepth();
                if (depth == -1) {
                    if (this.fThread.isSuspended()) {
                        this.fThread.computeStackFrames();
                        depth = this.getDepth();
                        if (depth == -1) {
                            throw new DebugException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 4, JDIDebugModelMessages.getString("JDIStackFrame.25"), null));
                        }
                    } else {
                        throw new DebugException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 100, JDIDebugModelMessages.getString("JDIStackFrame.25"), null));
                    }
                }
                this.setUnderlyingStackFrame(((JDIThread)this.getThread()).getUnderlyingFrame(depth));
            }
            return this.fStackFrame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUnderlyingStackFrame(StackFrame frame) {
        JDIThread jDIThread = this.fThread;
        synchronized (jDIThread) {
            this.fStackFrame = frame;
            if (frame == null) {
                this.fDepth = -1;
                this.fRefreshVariables = true;
            }
        }
    }

    protected Method getLastMethod() {
        return this.fLastMethod;
    }

    protected void setThread(JDIThread thread) {
        this.fThread = thread;
    }

    protected void setVariables(List variables) {
        this.fVariables = variables;
    }

    public IJavaVariable[] getLocalVariables() throws DebugException {
        List list = this.getUnderlyingVisibleVariables();
        IJavaVariable[] locals = new IJavaVariable[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            locals[i] = new JDILocalVariable(this, (LocalVariable)list.get(i));
        }
        return locals;
    }

    public IJavaObject getThis() throws DebugException {
        ObjectReference thisObject;
        IJavaObject receiver = null;
        if (!this.isStatic() && (thisObject = this.getUnderlyingThisObject()) != null) {
            receiver = (IJavaObject)((Object)JDIValue.createValue((JDIDebugTarget)this.getDebugTarget(), thisObject));
        }
        return receiver;
    }

    public IRegisterGroup[] getRegisterGroups() {
        return new IRegisterGroup[0];
    }

    public IJavaClassType getDeclaringType() throws DebugException {
        Method method = this.getUnderlyingMethod();
        try {
            ReferenceType type = method.declaringType();
            return (IJavaClassType)((Object)JDIType.createType((JDIDebugTarget)this.getDebugTarget(), type));
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIStackFrame.exception_retreiving_declaring_type"), e.toString()), e);
            return null;
        }
    }

    public int getCharEnd() {
        return -1;
    }

    public int getCharStart() {
        return -1;
    }

    private void clearCachedData() {
        this.fMethod = null;
        this.fThisObject = null;
        this.fDeclaringTypeName = null;
        this.fReceivingTypeName = null;
        this.fSourceName = null;
    }

    public boolean wereLocalsAvailable() {
        return this.fLocalsAvailable;
    }

    private void setLocalsAvailable(boolean available) {
        if (available != this.fLocalsAvailable) {
            this.fLocalsAvailable = available;
            this.fireChangeEvent(256);
        }
    }

    public boolean hasRegisterGroups() {
        return false;
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables0().size() > 0;
    }

    public boolean canStepWithFilters() {
        if (this.canStepInto()) {
            String[] filters = this.getJavaDebugTarget().getStepFilters();
            return filters != null && filters.length > 0;
        }
        return false;
    }

    public void stepWithFilters() throws DebugException {
        ((IJavaThread)this.getThread()).stepWithFilters();
    }

    public String getSourcePath(String stratum) throws DebugException {
        try {
            return this.getUnderlyingStackFrame().location().sourcePath(stratum);
        }
        catch (AbsentInformationException e) {
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIStackFrame.exception_retrieving_source_path"), e.toString()), e);
        }
        return null;
    }

    public String getSourcePath() throws DebugException {
        try {
            return this.getUnderlyingStackFrame().location().sourcePath();
        }
        catch (AbsentInformationException e) {
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIStackFrame.exception_retrieving_source_path"), e.toString()), e);
        }
        return null;
    }

    public int getLineNumber(String stratum) throws DebugException {
        block3: {
            if (this.isSuspended()) {
                try {
                    return this.getUnderlyingStackFrame().location().lineNumber(stratum);
                }
                catch (RuntimeException e) {
                    if (!this.getThread().isSuspended()) break block3;
                    this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIStackFrame.exception_retrieving_line_number"), e.toString()), e);
                }
            }
        }
        return -1;
    }

    public String getSourceName(String stratum) throws DebugException {
        try {
            return this.getUnderlyingStackFrame().location().sourceName(stratum);
        }
        catch (AbsentInformationException e) {
        }
        catch (NativeMethodException e) {
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIStackFrame.exception_retrieving_source_name"), e.toString()), e);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

