/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIVariable;

public class JDIThisVariable
extends JDIVariable {
    private ObjectReference fObject;

    public JDIThisVariable(JDIDebugTarget target, ObjectReference object) {
        super(target);
        this.fObject = object;
    }

    protected Value retrieveValue() {
        return this.fObject;
    }

    public String getName() {
        return "this";
    }

    public String getSignature() throws DebugException {
        try {
            return this.retrieveValue().type().signature();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThisVariableexception_retrieving_type_signature"), e.toString()), e);
            return null;
        }
    }

    public String getReferenceTypeName() throws DebugException {
        try {
            return this.getValue().getReferenceTypeName();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThisVariableexception_retrieving_reference_type_name"), e.toString()), e);
            return null;
        }
    }

    protected Type getUnderlyingType() throws DebugException {
        try {
            return this.retrieveValue().type();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.getString("JDIThisVariable.exception_while_retrieving_type_this"), e.toString()), e);
            return null;
        }
    }

    public boolean isPrivate() throws DebugException {
        try {
            return ((ReferenceType)this.getUnderlyingType()).isPrivate();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(JDIDebugModelMessages.getString("JDIThisVariable.Exception_occurred_while_retrieving_modifiers._1"), e);
            return false;
        }
    }

    public boolean isProtected() throws DebugException {
        try {
            return ((ReferenceType)this.getUnderlyingType()).isProtected();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(JDIDebugModelMessages.getString("JDIThisVariable.Exception_occurred_while_retrieving_modifiers._1"), e);
            return false;
        }
    }

    public boolean isPublic() throws DebugException {
        try {
            return ((ReferenceType)this.getUnderlyingType()).isPublic();
        }
        catch (RuntimeException e) {
            this.targetRequestFailed(JDIDebugModelMessages.getString("JDIThisVariable.Exception_occurred_while_retrieving_modifiers._1"), e);
            return false;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof JDIThisVariable) {
            return ((Object)((JDIThisVariable)o).fObject).equals(this.fObject);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.fObject).hashCode();
    }
}

