/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;

public class ChooseWorkspaceData {
    private static final int RECENT_MAX_LENGTH = 5;
    private static final String PERS_FOLDER = "org.eclipse.ui.ide";
    private static final String PERS_FILENAME = "recentWorkspaces.xml";
    private static final int PERS_ENCODING_VERSION = 1;
    private boolean showDialog = true;
    private String initialDefault;
    private String selection;
    private String[] recentWorkspaces;

    public ChooseWorkspaceData(String initialDefault) {
        this.readPersistedData();
        this.setInitialDefault(initialDefault);
    }

    public ChooseWorkspaceData(URL instanceUrl) {
        this.readPersistedData();
        if (instanceUrl != null) {
            this.setInitialDefault(new File(instanceUrl.getFile()).toString());
        }
    }

    public String getInitialDefault() {
        if (this.initialDefault == null) {
            this.setInitialDefault(System.getProperty("user.dir") + File.separator + "workspace");
        }
        return this.initialDefault;
    }

    private void setInitialDefault(String dir) {
        if (dir == null || dir.length() <= 0) {
            this.initialDefault = null;
            return;
        }
        dir = new Path(dir).toOSString();
        while (dir.charAt(dir.length() - 1) == File.separatorChar) {
            dir = dir.substring(0, dir.length() - 1);
        }
        this.initialDefault = dir;
    }

    public String getSelection() {
        return this.selection;
    }

    public boolean getShowDialog() {
        return this.showDialog;
    }

    public String[] getRecentWorkspaces() {
        return this.recentWorkspaces;
    }

    public void workspaceSelected(String dir) {
        this.selection = dir;
    }

    public void toggleShowDialog() {
        this.showDialog = !this.showDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writePersistedData() {
        Location configLoc = Platform.getConfigurationLocation();
        if (configLoc == null || configLoc.isReadOnly()) {
            return;
        }
        URL persUrl = ChooseWorkspaceData.getPersistenceUrl(configLoc.getURL(), true);
        if (persUrl == null) {
            return;
        }
        if (this.selection != null) {
            String oldEntry = this.recentWorkspaces[0];
            this.recentWorkspaces[0] = this.selection;
            for (int i = 1; i < this.recentWorkspaces.length && oldEntry != null && !this.selection.equals(oldEntry); ++i) {
                String tmp = this.recentWorkspaces[i];
                this.recentWorkspaces[i] = oldEntry;
                oldEntry = tmp;
            }
        }
        FileWriter writer = null;
        writer = new FileWriter(persUrl.getFile());
        XMLMemento memento = XMLMemento.createWriteRoot((String)"launchWorkspaceData");
        memento.createChild("protocol").putInteger("version", 1);
        memento.createChild("alwaysAsk").putInteger("showDialog", this.showDialog ? 1 : 0);
        IMemento recentMemento = memento.createChild("recentWorkspaces");
        recentMemento.putInteger("maxLength", this.recentWorkspaces.length);
        for (int i = 0; i < this.recentWorkspaces.length && this.recentWorkspaces[i] != null; ++i) {
            recentMemento.createChild("workspace").putString("path", this.recentWorkspaces[i]);
        }
        memento.save((Writer)writer);
        Object var8_9 = null;
        if (writer == null) return;
        try {
            ((Writer)writer).close();
            return;
        }
        catch (IOException e1) {}
        return;
        {
            catch (IOException e) {
                IDEWorkbenchPlugin.log("Unable to write recent workspace data", StatusUtil.newStatus(4, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e));
                Object var8_10 = null;
                if (writer == null) return;
                try {
                    ((Writer)writer).close();
                    return;
                }
                catch (IOException e1) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (writer == null) throw throwable;
            try {
                ((Writer)writer).close();
                throw throwable;
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readPersistedData() {
        block17: {
            boolean bl;
            block16: {
                boolean bl2;
                block15: {
                    boolean bl3;
                    block14: {
                        boolean bl4;
                        block13: {
                            URL persUrl = null;
                            Location configLoc = Platform.getConfigurationLocation();
                            if (configLoc != null) {
                                persUrl = ChooseWorkspaceData.getPersistenceUrl(configLoc.getURL(), false);
                            }
                            try {
                                try {
                                    String path;
                                    IMemento[] indices;
                                    if (persUrl == null) {
                                        bl4 = false;
                                        Object var13_7 = null;
                                        if (this.recentWorkspaces != null) return bl4;
                                        break block13;
                                    }
                                    FileReader reader = new FileReader(persUrl.getFile());
                                    XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                                    if (memento == null || !ChooseWorkspaceData.compatibleProtocol((IMemento)memento)) {
                                        bl3 = false;
                                        break block14;
                                    }
                                    IMemento alwaysAskTag = memento.getChild("alwaysAsk");
                                    this.showDialog = alwaysAskTag == null ? true : alwaysAskTag.getInteger("showDialog") == 1;
                                    IMemento recent = memento.getChild("recentWorkspaces");
                                    if (recent == null) {
                                        bl2 = false;
                                        break block15;
                                    }
                                    Integer maxLength = recent.getInteger("maxLength");
                                    int max = 5;
                                    if (maxLength != null) {
                                        max = maxLength;
                                    }
                                    if ((indices = recent.getChildren("workspace")) == null || indices.length <= 0) {
                                        bl = false;
                                        break block16;
                                    }
                                    max = Math.max(max, indices.length);
                                    this.recentWorkspaces = new String[max];
                                    for (int i = 0; i < indices.length && (path = indices[i].getString("path")) != null; ++i) {
                                        this.recentWorkspaces[i] = path;
                                    }
                                    break block17;
                                }
                                catch (IOException e) {
                                    boolean bl5 = false;
                                    Object var13_12 = null;
                                    if (this.recentWorkspaces != null) return bl5;
                                    this.recentWorkspaces = new String[5];
                                    return bl5;
                                }
                                catch (WorkbenchException e) {
                                    boolean bl6 = false;
                                    Object var13_13 = null;
                                    if (this.recentWorkspaces != null) return bl6;
                                    this.recentWorkspaces = new String[5];
                                    return bl6;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var13_14 = null;
                                if (this.recentWorkspaces != null) throw throwable;
                                this.recentWorkspaces = new String[5];
                                throw throwable;
                            }
                        }
                        this.recentWorkspaces = new String[5];
                        return bl4;
                    }
                    Object var13_8 = null;
                    if (this.recentWorkspaces != null) return bl3;
                    this.recentWorkspaces = new String[5];
                    return bl3;
                }
                Object var13_9 = null;
                if (this.recentWorkspaces != null) return bl2;
                this.recentWorkspaces = new String[5];
                return bl2;
            }
            Object var13_10 = null;
            if (this.recentWorkspaces != null) return bl;
            this.recentWorkspaces = new String[5];
            return bl;
        }
        Object var13_11 = null;
        if (this.recentWorkspaces != null) return true;
        this.recentWorkspaces = new String[5];
        return true;
    }

    public static boolean getShowDialogValue() {
        ChooseWorkspaceData data = new ChooseWorkspaceData("");
        return data.readPersistedData() ? data.showDialog : true;
    }

    public static void setShowDialogValue(boolean showDialog) {
        ChooseWorkspaceData data = new ChooseWorkspaceData("");
        if (!data.readPersistedData()) {
            return;
        }
        data.showDialog = showDialog;
        data.writePersistedData();
    }

    private static boolean compatibleProtocol(IMemento memento) {
        IMemento protocolMemento = memento.getChild("protocol");
        if (protocolMemento == null) {
            return false;
        }
        Integer version = protocolMemento.getInteger("version");
        return version != null && version == 1;
    }

    private static URL getPersistenceUrl(URL baseUrl, boolean create) {
        if (baseUrl == null) {
            return null;
        }
        try {
            URL url = new URL(baseUrl, PERS_FOLDER);
            File dir = new File(url.getFile());
            if (!(dir.exists() || create && dir.mkdir())) {
                return null;
            }
            url = new URL(dir.toURL(), PERS_FILENAME);
            File persFile = new File(url.getFile());
            if (!(persFile.exists() || create && persFile.createNewFile())) {
                return null;
            }
            return persFile.toURL();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static interface XML {
        public static final String PROTOCOL = "protocol";
        public static final String VERSION = "version";
        public static final String ALWAYS_ASK = "alwaysAsk";
        public static final String SHOW_DIALOG = "showDialog";
        public static final String WORKSPACE = "workspace";
        public static final String RECENT_WORKSPACES = "recentWorkspaces";
        public static final String MAX_LENGTH = "maxLength";
        public static final String PATH = "path";
    }
}

