/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.views.markers.internal.Messages;
import org.eclipse.ui.views.markers.internal.Util;

public class ActionPasteMarker
extends SelectionProviderAction {
    private IWorkbenchPart part;
    private Clipboard clipboard;
    private String[] pastableTypes;

    public ActionPasteMarker(IWorkbenchPart part, ISelectionProvider provider) {
        super(provider, Messages.getString("pasteAction.title"));
        this.part = part;
        this.pastableTypes = new String[0];
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
        this.setEnabled(false);
    }

    void setClipboard(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    public void run() {
        MarkerTransfer transfer = MarkerTransfer.getInstance();
        IMarker[] markerData = (IMarker[])this.clipboard.getContents((Transfer)transfer);
        this.paste(markerData);
    }

    void paste(final IMarker[] markers) {
        if (markers == null) {
            return;
        }
        final ArrayList newMarkers = new ArrayList();
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    for (int i = 0; i < markers.length; ++i) {
                        String type = markers[i].getType();
                        IResource resource = markers[i].getResource();
                        Map attributes = markers[i].getAttributes();
                        IMarker marker = resource.createMarker(type);
                        marker.setAttributes(attributes);
                        newMarkers.add(marker);
                    }
                }
            }, null);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.part.getSite().getShell(), (String)Messages.getString("PasteMarker.errorTitle"), null, (IStatus)e.getStatus());
            return;
        }
        if (this.getSelectionProvider() != null && newMarkers.size() > 0) {
            this.part.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ActionPasteMarker.this.getSelectionProvider().setSelection((ISelection)new StructuredSelection((List)newMarkers));
                }
            });
        }
    }

    void updateEnablement() {
        this.setEnabled(false);
        if (this.clipboard == null) {
            return;
        }
        MarkerTransfer transfer = MarkerTransfer.getInstance();
        IMarker[] markerData = (IMarker[])this.clipboard.getContents((Transfer)transfer);
        if (markerData == null || markerData.length < 1 || this.pastableTypes == null) {
            return;
        }
        for (int i = 0; i < markerData.length; ++i) {
            try {
                IMarker marker = markerData[i];
                if (!marker.exists()) break;
                boolean pastable = false;
                for (int j = 0; j < this.pastableTypes.length; ++j) {
                    if (!marker.isSubtypeOf(this.pastableTypes[j])) continue;
                    pastable = true;
                    break;
                }
                if (!pastable) {
                    return;
                }
                if (Util.isEditable(marker)) continue;
                return;
            }
            catch (CoreException e) {
                return;
            }
        }
        this.setEnabled(true);
    }

    void setPastableTypes(String[] strings) {
        this.pastableTypes = strings;
    }
}

