/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.views.markers.internal.BookmarkMarker;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.ProblemMarker;
import org.eclipse.ui.views.markers.internal.TaskMarker;

public class MarkerList {
    private int[] markerCounts = null;
    private ConcreteMarker[] markers;
    private Map markerTable;

    public MarkerList() {
        this(new ConcreteMarker[0]);
    }

    public MarkerList(Collection markers) {
        this(markers.toArray(new ConcreteMarker[markers.size()]));
    }

    public MarkerList(ConcreteMarker[] markers) {
        this.markers = markers;
    }

    public void clearCache() {
        for (int i = 0; i < this.markers.length; ++i) {
            ConcreteMarker marker = this.markers[i];
            marker.clearCache();
        }
        this.markerTable = null;
    }

    private Map getMarkerMap() {
        if (this.markerTable == null) {
            this.markerTable = new HashMap();
            for (int idx = 0; idx < this.markers.length; ++idx) {
                ConcreteMarker marker = this.markers[idx];
                this.markerTable.put(marker.getMarker(), marker);
            }
        }
        return this.markerTable;
    }

    public ConcreteMarker getMarker(IMarker toFind) {
        return (ConcreteMarker)this.getMarkerMap().get(toFind);
    }

    public static ConcreteMarker createMarker(IMarker marker) throws CoreException {
        if (marker.isSubtypeOf("org.eclipse.core.resources.taskmarker")) {
            return new TaskMarker(marker);
        }
        if (marker.isSubtypeOf("org.eclipse.core.resources.bookmark")) {
            return new BookmarkMarker(marker);
        }
        if (marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
            return new ProblemMarker(marker);
        }
        return new ConcreteMarker(marker);
    }

    public void refresh() {
        for (int markerIdx = 0; markerIdx < this.markers.length; ++markerIdx) {
            ConcreteMarker next = this.markers[markerIdx];
            next.refresh();
        }
    }

    public List asList() {
        return Arrays.asList(this.markers);
    }

    public MarkerList findMarkers(Collection ofIMarker) {
        ArrayList<ConcreteMarker> result = new ArrayList<ConcreteMarker>(ofIMarker.size());
        Iterator iter = ofIMarker.iterator();
        while (iter.hasNext()) {
            IMarker next = (IMarker)iter.next();
            ConcreteMarker marker = this.getMarker(next);
            if (marker == null) continue;
            result.add(marker);
        }
        return new MarkerList(result);
    }

    public static ConcreteMarker[] createMarkers(IMarker[] source) throws CoreException {
        ConcreteMarker[] result = new ConcreteMarker[source.length];
        for (int idx = 0; idx < source.length; ++idx) {
            result[idx] = MarkerList.createMarker(source[idx]);
        }
        return result;
    }

    public static MarkerList compute(MarkerFilter filter, IProgressMonitor mon, boolean ignoreExceptions) throws CoreException {
        return new MarkerList(filter.findMarkers(mon, ignoreExceptions));
    }

    public static IMarker[] compute(String[] types) throws CoreException {
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        IWorkspaceRoot input = ResourcesPlugin.getWorkspace().getRoot();
        for (int i = 0; i < types.length; ++i) {
            IMarker[] newMarkers = input.findMarkers(types[i], true, 2);
            result.addAll(Arrays.asList(newMarkers));
        }
        return result.toArray(new IMarker[result.size()]);
    }

    public ConcreteMarker[] toArray() {
        return this.markers;
    }

    public int getItemCount() {
        return this.markers.length;
    }

    public int getErrors() {
        return this.getMarkerCounts()[2];
    }

    public int getInfos() {
        return this.getMarkerCounts()[0];
    }

    public int getWarnings() {
        return this.getMarkerCounts()[1];
    }

    private int[] getMarkerCounts() {
        if (this.markerCounts == null) {
            this.markerCounts = new int[]{0, 0, 0};
            for (int idx = 0; idx < this.markers.length; ++idx) {
                int severity;
                ConcreteMarker marker = this.markers[idx];
                if (!(marker instanceof ProblemMarker) || (severity = ((ProblemMarker)this.markers[idx]).getSeverity()) < 0 || severity > 2) continue;
                int n = severity;
                this.markerCounts[n] = this.markerCounts[n] + 1;
            }
        }
        return this.markerCounts;
    }
}

