/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.navigator.ResourcePatternFilter;

class FiltersContentProvider
implements IStructuredContentProvider {
    private static List definedFilters;
    private static List defaultFilters;
    private ResourcePatternFilter resourceFilter;

    public FiltersContentProvider(ResourcePatternFilter filter) {
        this.resourceFilter = filter;
    }

    public void dispose() {
    }

    public static List getDefaultFilters() {
        if (defaultFilters == null) {
            FiltersContentProvider.readFilters();
        }
        return defaultFilters;
    }

    public static List getDefinedFilters() {
        if (definedFilters == null) {
            FiltersContentProvider.readFilters();
        }
        return definedFilters;
    }

    public Object[] getElements(Object inputElement) {
        return FiltersContentProvider.getDefinedFilters().toArray();
    }

    public String[] getInitialSelections() {
        return this.resourceFilter.getPatterns();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private static void readFilters() {
        IExtensionPoint extension;
        definedFilters = new ArrayList();
        defaultFilters = new ArrayList();
        AbstractUIPlugin plugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui.ide");
        if (plugin != null && (extension = plugin.getDescriptor().getExtensionPoint("resourceFilters")) != null) {
            IExtension[] extensions = extension.getExtensions();
            for (int i = 0; i < extensions.length; ++i) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                for (int j = 0; j < configElements.length; ++j) {
                    String selected;
                    String pattern = configElements[j].getAttribute("pattern");
                    if (pattern != null) {
                        definedFilters.add(pattern);
                    }
                    if ((selected = configElements[j].getAttribute("selected")) == null || !selected.equalsIgnoreCase("true")) continue;
                    defaultFilters.add(pattern);
                }
            }
        }
    }
}

