/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.jdt.internal.corext.refactoring.code.TempAssignmentFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempDeclarationFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempOccurrenceAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.reorg.SourceRangeComputer;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class InlineTempRefactoring
extends Refactoring {
    private final int fSelectionStart;
    private final int fSelectionLength;
    private final ICompilationUnit fCu;
    private VariableDeclaration fTempDeclaration;
    private CompilationUnit fCompilationUnitNode;
    private int[] fReferenceOffsets;

    private InlineTempRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength) {
        Assert.isTrue(selectionStart >= 0);
        Assert.isTrue(selectionLength >= 0);
        Assert.isTrue(cu.exists());
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = cu;
    }

    public static boolean isAvailable(ILocalVariable variable) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)variable);
    }

    public static InlineTempRefactoring create(ICompilationUnit unit, int selectionStart, int selectionLength) {
        InlineTempRefactoring ref = new InlineTempRefactoring(unit, selectionStart, selectionLength);
        if (ref.checkIfTempSelected().hasFatalError()) {
            return null;
        }
        return ref;
    }

    private RefactoringStatus checkIfTempSelected() {
        this.initializeAST();
        this.fTempDeclaration = TempDeclarationFinder.findTempDeclaration(this.fCompilationUnitNode, this.fSelectionStart, this.fSelectionLength);
        if (this.fTempDeclaration == null) {
            String message = RefactoringCoreMessages.getString("InlineTempRefactoring.select_temp");
            return CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.fCompilationUnitNode, message);
        }
        if (this.fTempDeclaration.getParent() instanceof FieldDeclaration) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("InlineTemRefactoring.error.message.fieldsCannotBeInlined"));
        }
        return new RefactoringStatus();
    }

    private void initializeAST() {
        this.fCompilationUnitNode = new RefactoringASTParser(2).parse(this.fCu, true);
    }

    public String getName() {
        return RefactoringCoreMessages.getString("InlineTempRefactoring.name");
    }

    public String getTempName() {
        return this.fTempDeclaration.getName().getIdentifier();
    }

    public int getReferencesCount() {
        return this.getReferenceOffsets().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 1);
            RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (!this.fCu.isStructureKnown()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("InlineTempRefactoring.syntax_errors"));
                return refactoringStatus;
            }
            result.merge(this.checkSelection());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.checkInitializer());
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkInitializer() {
        switch (this.fTempDeclaration.getInitializer().getNodeType()) {
            case 33: {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("InlineTemRefactoring.error.message.nulLiteralsCannotBeInlined"));
            }
            case 4: {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("InlineTempRefactoring.Array_vars_initialized"));
            }
        }
        return null;
    }

    private RefactoringStatus checkSelection() {
        if (this.fTempDeclaration.getParent() instanceof MethodDeclaration) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("InlineTempRefactoring.method_parameter"));
        }
        if (this.fTempDeclaration.getParent() instanceof CatchClause) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("InlineTempRefactoring.exceptions_declared"));
        }
        if (ASTNodes.getParent((ASTNode)this.fTempDeclaration, 24) != null) {
            ForStatement forStmt = (ForStatement)ASTNodes.getParent((ASTNode)this.fTempDeclaration, 24);
            Iterator iter = forStmt.initializers().iterator();
            while (iter.hasNext()) {
                if (!ASTNodes.isParent((ASTNode)this.fTempDeclaration, (ASTNode)((Expression)iter.next()))) continue;
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.getString("InlineTempRefactoring.for_initializers"));
            }
        }
        if (this.fTempDeclaration.getInitializer() == null) {
            String message = RefactoringCoreMessages.getFormattedString("InlineTempRefactoring.not_initialized", this.getTempName());
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        return this.checkAssignments();
    }

    private RefactoringStatus checkAssignments() {
        TempAssignmentFinder assignmentFinder = new TempAssignmentFinder(this.fTempDeclaration);
        this.fCompilationUnitNode.accept((ASTVisitor)assignmentFinder);
        if (!assignmentFinder.hasAssignments()) {
            return new RefactoringStatus();
        }
        int start = assignmentFinder.getFirstAssignment().getStartPosition();
        int length = assignmentFinder.getFirstAssignment().getLength();
        SourceRange range = new SourceRange(start, length);
        RefactoringStatusContext context = JavaStatusContext.create(this.fCu, range);
        String message = RefactoringCoreMessages.getFormattedString("InlineTempRefactoring.assigned_more_once", this.getTempName());
        return RefactoringStatus.createFatalErrorStatus((String)message, (RefactoringStatusContext)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 1);
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change createChange(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.getString("InlineTempRefactoring.preview"), 2);
            CompilationUnitChange result = new CompilationUnitChange(RefactoringCoreMessages.getString("InlineTempRefactoring.inline"), this.fCu);
            this.inlineTemp((TextChange)result, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            this.removeTemp((TextChange)result);
            CompilationUnitChange compilationUnitChange = result;
            return compilationUnitChange;
        }
        finally {
            pm.done();
        }
    }

    private void inlineTemp(TextChange change, IProgressMonitor pm) throws JavaModelException {
        int[] offsets = this.getReferenceOffsets();
        pm.beginTask("", offsets.length);
        String changeName = RefactoringCoreMessages.getString("InlineTempRefactoring.inline_edit_name") + this.getTempName();
        int length = this.getTempName().length();
        for (int i = 0; i < offsets.length; ++i) {
            int offset = offsets[i];
            String sourceToInline = this.getInitializerSource(this.needsBrackets(offset));
            TextChangeCompatibility.addTextEdit(change, changeName, (TextEdit)new ReplaceEdit(offset, length, sourceToInline));
            pm.worked(1);
        }
    }

    private boolean needsBrackets(int offset) {
        Expression initializer = this.fTempDeclaration.getInitializer();
        if (initializer instanceof Assignment) {
            return true;
        }
        SimpleName inlineSite = this.getReferenceAtOffset(offset);
        if (inlineSite == null) {
            return true;
        }
        return ASTNodes.substituteMustBeParenthesized(initializer, (Expression)inlineSite);
    }

    private SimpleName getReferenceAtOffset(int offset) {
        SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength(offset, this.getTempName().length()), true);
        this.fCompilationUnitNode.accept((ASTVisitor)analyzer);
        ASTNode reference = analyzer.getFirstSelectedNode();
        if (!this.isReference(reference)) {
            return null;
        }
        return (SimpleName)reference;
    }

    private boolean isReference(ASTNode node) {
        if (!(node instanceof SimpleName)) {
            return false;
        }
        return ((SimpleName)node).getIdentifier().equals(this.fTempDeclaration.getName().getIdentifier());
    }

    private void removeTemp(TextChange change) throws JavaModelException {
        if (this.fTempDeclaration.getParent() instanceof VariableDeclarationStatement) {
            VariableDeclarationStatement vds = (VariableDeclarationStatement)this.fTempDeclaration.getParent();
            if (vds.fragments().size() == 1) {
                this.removeDeclaration(change, vds.getStartPosition(), vds.getLength());
                return;
            }
            return;
        }
        this.removeDeclaration(change, this.fTempDeclaration.getStartPosition(), this.fTempDeclaration.getLength());
    }

    private void removeDeclaration(TextChange change, int offset, int length) throws JavaModelException {
        ISourceRange range = SourceRangeComputer.computeSourceRange(new SourceRange(offset, length), this.fCu.getSource());
        String changeName = RefactoringCoreMessages.getString("InlineTempRefactoring.remove_edit_name") + this.getTempName();
        TextChangeCompatibility.addTextEdit(change, changeName, (TextEdit)new DeleteEdit(range.getOffset(), range.getLength()));
    }

    private String getInitializerSource(boolean brackets) throws JavaModelException {
        if (brackets) {
            return '(' + this.getRawInitializerSource() + ')';
        }
        return this.getRawInitializerSource();
    }

    private String getRawInitializerSource() throws JavaModelException {
        int start = this.fTempDeclaration.getInitializer().getStartPosition();
        int length = this.fTempDeclaration.getInitializer().getLength();
        int end = start + length;
        return this.fCu.getSource().substring(start, end);
    }

    private int[] getReferenceOffsets() {
        if (this.fReferenceOffsets == null) {
            TempOccurrenceAnalyzer analyzer = new TempOccurrenceAnalyzer(this.fTempDeclaration, false);
            analyzer.perform();
            this.fReferenceOffsets = analyzer.getReferenceOffsets();
        }
        return this.fReferenceOffsets;
    }
}

