/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.viewsupport.IProblemChangedListener;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jface.text.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

public class JavaEditorErrorTickUpdater
implements IProblemChangedListener {
    private JavaEditor fJavaEditor;
    private JavaUILabelProvider fLabelProvider;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;

    public JavaEditorErrorTickUpdater(JavaEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fJavaEditor = editor;
        this.fLabelProvider = new JavaUILabelProvider(0, 2);
        this.fLabelProvider.addLabelDecorator(new ProblemsLabelDecorator(null));
        JavaPlugin.getDefault().getProblemMarkerManager().addListener(this);
    }

    public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        IJavaElement jelement;
        if (isMarkerChange) {
            return;
        }
        IEditorInput input = this.fJavaEditor.getEditorInput();
        if (input != null && (jelement = (IJavaElement)input.getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = JavaEditorErrorTickUpdater.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement)) != null) {
            IResource resource = jelement.getResource();
            for (int i = 0; i < changedResources.length; ++i) {
                if (!changedResources[i].equals(resource)) continue;
                this.updateEditorImage(jelement);
            }
        }
    }

    public void updateEditorImage(IJavaElement jelement) {
        Image titleImage = this.fJavaEditor.getTitleImage();
        if (titleImage == null) {
            return;
        }
        Image newImage = this.fLabelProvider.getImage(jelement);
        if (titleImage != newImage) {
            this.postImageChange(newImage);
        }
    }

    private void postImageChange(final Image newImage) {
        Shell shell = this.fJavaEditor.getEditorSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    JavaEditorErrorTickUpdater.this.fJavaEditor.updatedTitleImage(newImage);
                }
            });
        }
    }

    public void dispose() {
        this.fLabelProvider.dispose();
        JavaPlugin.getDefault().getProblemMarkerManager().removeListener(this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

