/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.jdt.internal.ui.text.JavaPairMatcher;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class JavaDoubleClickSelector
implements ITextDoubleClickStrategy {
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    protected JavaPairMatcher fPairMatcher = new JavaPairMatcher(BRACKETS);

    public void doubleClicked(ITextViewer textViewer) {
        int offset = textViewer.getSelectedRange().x;
        if (offset < 0) {
            return;
        }
        IDocument document = textViewer.getDocument();
        IRegion region = this.fPairMatcher.match(document, offset);
        if (region != null && region.getLength() >= 2) {
            textViewer.setSelectedRange(region.getOffset() + 1, region.getLength() - 2);
        } else {
            this.selectWord(textViewer, document, offset);
        }
    }

    protected void selectWord(ITextViewer textViewer, IDocument document, int anchor) {
        try {
            char c;
            int offset;
            for (offset = anchor; offset >= 0 && Character.isJavaIdentifierPart(c = document.getChar(offset)); --offset) {
            }
            int start = offset;
            int length = document.getLength();
            for (offset = anchor; offset < length && Character.isJavaIdentifierPart(c = document.getChar(offset)); ++offset) {
            }
            int end = offset;
            if (start == end) {
                textViewer.setSelectedRange(start, 0);
            } else {
                textViewer.setSelectedRange(start + 1, end - start - 1);
            }
        }
        catch (BadLocationException x) {
            // empty catch block
        }
    }
}

