/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.internal.INavigatable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.actions.OpenInCompareAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;

public class NavigateAction
extends Action {
    private final boolean next;
    private ISynchronizePageSite site;
    private String title;
    private ISynchronizePageConfiguration configuration;
    static /* synthetic */ Class class$org$eclipse$compare$ICompareNavigator;

    public NavigateAction(ISynchronizePageSite site, String title, ISynchronizePageConfiguration configuration, boolean next) {
        this.site = site;
        this.title = title;
        this.configuration = configuration;
        this.next = next;
        IActionBars bars = site.getActionBars();
        if (next) {
            Utils.initAction((IAction)this, "action.navigateNext.");
            if (bars != null) {
                bars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this);
            }
        } else {
            Utils.initAction((IAction)this, "action.navigatePrevious.");
            if (bars != null) {
                bars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this);
            }
        }
    }

    public void run() {
        IWorkbenchSite ws = this.site.getWorkbenchSite();
        INavigatable nav = (INavigatable)this.configuration.getProperty("org.eclipse.team.ui.P_NAVIGATOR");
        if (nav != null && ws != null && ws instanceof IViewSite) {
            this.navigate(nav);
        } else {
            nav.gotoDifference(this.next);
        }
    }

    private void navigate(INavigatable nav) {
        SyncInfo info = this.getSyncInfoFromSelection();
        if (info == null) {
            if (nav.gotoDifference(this.next)) {
                return;
            }
            info = this.getSyncInfoFromSelection();
            if (info == null) {
                return;
            }
        }
        if (info.getLocal().getType() != 1) {
            if (!nav.gotoDifference(this.next)) {
                info = this.getSyncInfoFromSelection();
                OpenInCompareAction.openCompareEditor(this.getTitle(), info, true, this.site);
            }
            return;
        }
        IWorkbenchSite ws = this.site.getWorkbenchSite();
        if (ws instanceof IWorkbenchPartSite) {
            IEditorPart editor = OpenInCompareAction.findOpenCompareEditor((IWorkbenchPartSite)ws, info.getLocal());
            if (editor != null) {
                CompareEditorInput input = (CompareEditorInput)editor.getEditorInput();
                ICompareNavigator navigator = (ICompareNavigator)input.getAdapter(class$org$eclipse$compare$ICompareNavigator == null ? (class$org$eclipse$compare$ICompareNavigator = NavigateAction.class$("org.eclipse.compare.ICompareNavigator")) : class$org$eclipse$compare$ICompareNavigator);
                if (navigator != null && navigator.selectChange(this.next) && !nav.gotoDifference(this.next)) {
                    info = this.getSyncInfoFromSelection();
                    OpenInCompareAction.openCompareEditor(this.getTitle(), info, true, this.site);
                }
            } else {
                OpenInCompareAction.openCompareEditor(this.getTitle(), info, true, this.site);
            }
        }
    }

    private SyncInfo getSyncInfoFromSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.site.getSelectionProvider().getSelection();
        if (selection == null) {
            return null;
        }
        Object obj = selection.getFirstElement();
        if (obj instanceof SyncInfoModelElement) {
            return ((SyncInfoModelElement)obj).getSyncInfo();
        }
        return null;
    }

    private String getTitle() {
        return this.title;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

