/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.search.PluginSearchActionGroup;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.extension.NewExtensionPointWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.FileEditorInput;

public class ExtensionPointsSection
extends TableSection {
    public static final String SECTION_TITLE = "ManifestEditor.DetailExtensionPointSection.title";
    public static final String SECTION_DESC = "ManifestEditor.DetailExtensionPointSection.desc";
    public static final String SECTION_NEW = "ManifestEditor.DetailExtensionPointSection.new";
    public static final String POPUP_NEW_EXTENSION_POINT = "ManifestEditor.DetailExtensionPointSection.newExtensionPoint";
    public static final String POPUP_OPEN_SCHEMA = "ManifestEditor.DetailExtensionPointSection.openSchema";
    public static final String POPUP_DELETE = "Actions.delete.label";
    private TableViewer pointTable;

    public ExtensionPointsSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{PDEPlugin.getResourceString(SECTION_NEW)});
        this.getSection().setText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.getSection().setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        this.handleDefaultButton = false;
        this.getTablePart().setEditable(false);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.createViewerPartControl(container, 2, 2, toolkit);
        this.pointTable = tablePart.getTableViewer();
        this.pointTable.setContentProvider((IContentProvider)new TableContentProvider());
        this.pointTable.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.pointTable.setInput((Object)this.getPage());
        this.selectFirstExtensionPoint();
        IBaseModel model = this.getPage().getModel();
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).addModelChangedListener((IModelChangedListener)this);
        }
        tablePart.setButtonEnabled(0, model.isEditable());
    }

    private void selectFirstExtensionPoint() {
        Table table = this.pointTable.getTable();
        TableItem[] items = table.getItems();
        if (items.length == 0) {
            return;
        }
        TableItem firstItem = items[0];
        Object obj = firstItem.getData();
        this.pointTable.setSelection((ISelection)new StructuredSelection(obj));
    }

    void fireSelection() {
        this.pointTable.setSelection(this.pointTable.getSelection());
    }

    public void dispose() {
        IBaseModel model = this.getPage().getModel();
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    public void refresh() {
        this.pointTable.refresh();
        this.getManagedForm().fireSelectionChanged((IFormPart)this, this.pointTable.getSelection());
        super.refresh();
    }

    public boolean setFormInput(Object object) {
        if (object instanceof IPluginExtensionPoint) {
            this.pointTable.setSelection((ISelection)new StructuredSelection(object), true);
            return true;
        }
        return false;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        super.selectionChanged(selection);
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.markStale();
            return;
        }
        Object changeObject = event.getChangedObjects()[0];
        if (changeObject instanceof IPluginExtensionPoint) {
            if (event.getChangeType() == 1) {
                this.pointTable.add(changeObject);
                this.pointTable.setSelection((ISelection)new StructuredSelection(changeObject), true);
                this.pointTable.getTable().setFocus();
            } else if (event.getChangeType() == 2) {
                this.pointTable.remove(changeObject);
            } else {
                this.pointTable.update(changeObject, null);
            }
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        ISelection selection = this.pointTable.getSelection();
        Action newAction = new Action(PDEPlugin.getResourceString(POPUP_NEW_EXTENSION_POINT)){

            public void run() {
                ExtensionPointsSection.this.handleNew();
            }
        };
        newAction.setEnabled(this.isEditable());
        manager.add((IAction)newAction);
        if (!selection.isEmpty()) {
            IEditorInput input;
            Object object = ((IStructuredSelection)selection).getFirstElement();
            final IPluginExtensionPoint point = (IPluginExtensionPoint)object;
            if (point.getSchema() != null && ((input = this.getPage().getEditor().getEditorInput()) instanceof IFileEditorInput || input instanceof SystemFileEditorInput)) {
                Action openSchemaAction = new Action(PDEPlugin.getResourceString(POPUP_OPEN_SCHEMA)){

                    public void run() {
                        ExtensionPointsSection.this.handleOpenSchema(point);
                    }
                };
                manager.add((IAction)openSchemaAction);
            }
            manager.add((IContributionItem)new Separator());
            Action deleteAction = new Action(PDEPlugin.getResourceString(POPUP_DELETE)){

                public void run() {
                    IPluginBase plugin = point.getPluginBase();
                    try {
                        plugin.remove(point);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            };
            deleteAction.setEnabled(this.isEditable());
            manager.add((IAction)deleteAction);
        }
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
        manager.add((IContributionItem)new Separator());
        if (!selection.isEmpty()) {
            PluginSearchActionGroup actionGroup = new PluginSearchActionGroup();
            actionGroup.setContext(new ActionContext(selection));
            actionGroup.fillContextMenu(manager);
        }
    }

    protected void buttonSelected(int index) {
        if (index == 0) {
            this.handleNew();
        }
    }

    private void handleDelete() {
        Object object = ((IStructuredSelection)this.pointTable.getSelection()).getFirstElement();
        if (object != null && object instanceof IPluginExtensionPoint) {
            IPluginExtensionPoint ep = (IPluginExtensionPoint)object;
            IPluginBase plugin = ep.getPluginBase();
            try {
                plugin.remove(ep);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void handleNew() {
        IFile file = ((IFileEditorInput)this.getPage().getPDEEditor().getEditorInput()).getFile();
        final IProject project = file.getProject();
        BusyIndicator.showWhile((Display)this.pointTable.getTable().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                NewExtensionPointWizard wizard = new NewExtensionPointWizard(project, (IPluginModelBase)ExtensionPointsSection.this.getPage().getModel(), (ManifestEditor)ExtensionPointsSection.this.getPage().getPDEEditor());
                WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                dialog.create();
                SWTUtil.setDialogSize((Dialog)dialog, 400, 450);
                dialog.open();
            }
        });
    }

    private void handleOpenSchema(IPluginExtensionPoint point) {
        Object input;
        String schema = point.getSchema();
        ISharedPluginModel model = point.getModel();
        IResource resource = model.getUnderlyingResource();
        final IWorkbenchPage page = PDEPlugin.getActivePage();
        if (resource != null) {
            IProject project = resource.getProject();
            IFile file = project.getFile(schema);
            input = new FileEditorInput(file);
        } else {
            File file;
            IPluginModelBase pmodel = (IPluginModelBase)model;
            String location = pmodel.getInstallLocation();
            if (location.startsWith("file:")) {
                location = location.substring(5);
            }
            if (!(file = new File(location + File.separator + schema)).exists()) {
                SourceLocationManager manager = PDECore.getDefault().getSourceLocationManager();
                file = manager.findSourceFile(point.getPluginBase(), (IPath)new Path(schema));
            }
            input = new SystemFileEditorInput(file);
        }
        BusyIndicator.showWhile((Display)this.pointTable.getTable().getDisplay(), (Runnable)new Runnable((IEditorInput)input){
            private final /* synthetic */ IEditorInput val$input;
            {
                this.val$input = val$input;
            }

            public void run() {
                try {
                    page.openEditor(this.val$input, "org.eclipse.pde.ui.schemaEditor");
                }
                catch (PartInitException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
    }

    protected void doPaste(Object target, Object[] objects) {
    }

    protected boolean canPaste(Object target, Object[] objects) {
        return objects[0] instanceof IPluginExtensionPoint;
    }

    class TableContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object parent) {
            IPluginModelBase model = (IPluginModelBase)ExtensionPointsSection.this.getPage().getModel();
            IPluginBase pluginBase = model.getPluginBase();
            if (pluginBase != null) {
                return pluginBase.getExtensionPoints();
            }
            return new Object[0];
        }
    }
}

