/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.search.PluginSearchInput;
import org.eclipse.pde.internal.core.search.PluginSearchScope;
import org.eclipse.pde.internal.ui.search.PluginSearchResultCollector;
import org.eclipse.pde.internal.ui.search.PluginSearchUIOperation;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class FindPluginReferencesAction
implements IObjectActionDelegate {
    private String searchString = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.searchString == null) {
            return;
        }
        PluginSearchInput input = new PluginSearchInput();
        input.setSearchElement(1);
        input.setSearchLimit(2);
        input.setSearchString(this.searchString);
        input.setSearchScope(new PluginSearchScope());
        try {
            SearchUI.activateSearchResultView();
            PluginSearchUIOperation op = new PluginSearchUIOperation(input, new PluginSearchResultCollector());
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sSelection;
        this.searchString = null;
        if (selection instanceof IStructuredSelection && (sSelection = (IStructuredSelection)selection).size() == 1) {
            IPluginModelBase model;
            IFile file = (IFile)sSelection.getFirstElement();
            ModelEntry entry = PDECore.getDefault().getModelManager().findEntry(file.getProject());
            if (entry != null && (model = entry.getActiveModel()) != null) {
                this.searchString = model.getPluginBase().getId();
            }
        }
    }
}

