/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.osgi.internal.resolver.BundleInstaller;
import org.eclipse.osgi.internal.resolver.ReadOnlyState;
import org.eclipse.osgi.internal.resolver.ResolverImpl;
import org.eclipse.osgi.internal.resolver.StateHelperImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.StateMsg;
import org.eclipse.osgi.internal.resolver.StateObjectFactoryImpl;
import org.eclipse.osgi.internal.resolver.UserState;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.osgi.framework.BundleException;

public class StateManager
implements PlatformAdmin {
    public static boolean DEBUG = false;
    public static boolean DEBUG_READER = false;
    public static boolean DEBUG_PLATFORM_ADMIN = false;
    public static boolean DEBUG_PLATFORM_ADMIN_RESOLVER = false;
    public static boolean MONITOR_PLATFORM_ADMIN = false;
    private long readStartupTime;
    private StateImpl systemState;
    private StateObjectFactoryImpl factory = new StateObjectFactoryImpl();
    private long lastTimeStamp;
    private BundleInstaller installer;
    private boolean cachedState = false;

    public StateManager(File stateLocation) {
        this(stateLocation, -1L);
    }

    public StateManager(File stateLocation, long expectedTimeStamp) {
        this.readState(stateLocation, expectedTimeStamp);
    }

    public void shutdown(File stateLocation) throws IOException {
        this.writeState(stateLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readState(File stateLocation, long expectedTimeStamp) {
        FileInputStream fileInput;
        if (!stateLocation.isFile()) {
            return;
        }
        if (DEBUG_READER) {
            this.readStartupTime = System.currentTimeMillis();
        }
        try {
            fileInput = new FileInputStream(stateLocation);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        DataInputStream input = null;
        try {
            try {
                input = new DataInputStream(new BufferedInputStream(fileInput, 65536));
                this.systemState = this.factory.readSystemState(input, expectedTimeStamp);
                if (this.systemState == null) {
                    Object var8_6 = null;
                    if (!DEBUG_READER) return;
                    System.out.println("Time to read state: " + (System.currentTimeMillis() - this.readStartupTime));
                    return;
                }
                this.initializeSystemState();
                this.cachedState = true;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                Object var8_8 = null;
                if (!DEBUG_READER) return;
                System.out.println("Time to read state: " + (System.currentTimeMillis() - this.readStartupTime));
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (!DEBUG_READER) throw throwable;
            System.out.println("Time to read state: " + (System.currentTimeMillis() - this.readStartupTime));
            throw throwable;
        }
        Object var8_7 = null;
        if (!DEBUG_READER) return;
        System.out.println("Time to read state: " + (System.currentTimeMillis() - this.readStartupTime));
    }

    private void writeState(File stateLocation) throws IOException {
        if (this.systemState == null) {
            return;
        }
        if (this.cachedState && this.lastTimeStamp == this.systemState.getTimeStamp()) {
            return;
        }
        DataOutputStream output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(stateLocation)));
        this.factory.writeState(this.systemState, output);
    }

    public StateImpl createSystemState() {
        this.systemState = this.factory.createSystemState();
        this.initializeSystemState();
        return this.systemState;
    }

    private void initializeSystemState() {
        this.systemState.setResolver(new ResolverImpl());
        this.lastTimeStamp = this.systemState.getTimeStamp();
    }

    public StateImpl getSystemState() {
        return this.systemState;
    }

    public State getState(boolean mutable) {
        return mutable ? this.factory.createState(this.systemState) : new ReadOnlyState(this.systemState);
    }

    public State getState() {
        return this.getState(true);
    }

    public StateObjectFactory getFactory() {
        return this.factory;
    }

    public synchronized void commit(State state) throws BundleException {
        if (this.installer == null) {
            throw new IllegalArgumentException("PlatformAdmin.commit() not supported");
        }
        if (!(state instanceof UserState)) {
            throw new IllegalArgumentException("Wrong state implementation");
        }
        if (state.getTimeStamp() != this.systemState.getTimeStamp()) {
            throw new BundleException(StateMsg.formatter.getString("COMMIT_INVALID_TIMESTAMP"));
        }
        StateDelta delta = state.compare((State)this.systemState);
        BundleDelta[] changes = delta.getChanges();
        for (int i = 0; i < changes.length; ++i) {
            if ((changes[i].getType() & 1) > 0) {
                this.installer.installBundle(changes[i].getBundle());
                continue;
            }
            if ((changes[i].getType() & 2) > 0) {
                this.installer.uninstallBundle(changes[i].getBundle());
                continue;
            }
            if ((changes[i].getType() & 4) <= 0) continue;
            this.installer.updateBundle(changes[i].getBundle());
        }
    }

    public Resolver getResolver() {
        return new ResolverImpl();
    }

    public StateHelper getStateHelper() {
        return StateHelperImpl.getInstance();
    }

    public BundleInstaller getInstaller() {
        return this.installer;
    }

    public void setInstaller(BundleInstaller installer) {
        this.installer = installer;
    }
}

