/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import org.eclipse.update.internal.core.Assert;

public class ListenersList {
    private int capacity;
    private int size;
    private Object[] listeners = null;
    private static final Object[] EmptyArray = new Object[0];

    public ListenersList() {
        this(3);
    }

    public ListenersList(int capacity) {
        Assert.isTrue(capacity >= 1);
        this.capacity = capacity;
    }

    public void add(Object listener) {
        Assert.isNotNull(listener);
        if (this.size == 0) {
            this.listeners = new Object[this.capacity];
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (this.listeners[i] != listener) continue;
                return;
            }
            if (this.size == this.listeners.length) {
                this.listeners = new Object[this.size * 2 + 1];
                System.arraycopy(this.listeners, 0, this.listeners, 0, this.size);
            }
        }
        this.listeners[this.size++] = listener;
    }

    public Object[] getListeners() {
        if (this.size == 0) {
            return EmptyArray;
        }
        Object[] result = new Object[this.size];
        System.arraycopy(this.listeners, 0, result, 0, this.size);
        return result;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void remove(Object listener) {
        Assert.isNotNull(listener);
        for (int i = 0; i < this.size; ++i) {
            if (this.listeners[i] != listener) continue;
            if (this.size == 1) {
                this.listeners = null;
                this.size = 0;
            } else {
                System.arraycopy(this.listeners, i + 1, this.listeners, i, --this.size - i);
                this.listeners[this.size] = null;
            }
            return;
        }
    }

    public int size() {
        return this.size;
    }
}

