/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.internal.mozilla.GRE;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIDirectoryServiceProvider;
import org.eclipse.swt.internal.mozilla.nsIDirectoryServiceProvider2;
import org.eclipse.swt.internal.mozilla.nsIFile;
import org.eclipse.swt.internal.mozilla.nsILocalFile;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.internal.mozilla.nsString;

class AppFileLocProvider {
    XPCOMObject supports;
    XPCOMObject directoryServiceProvider;
    XPCOMObject directoryServiceProvider2;
    int refCount = 0;
    String mozillaPath = GRE.mozillaPath;
    String grePath = GRE.grePath;

    public AppFileLocProvider() {
        if (this.mozillaPath == null) {
            Browser.error(-2147467259);
        }
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.supports = new XPCOMObject(new int[]{2, 0, 0}){

            public int method0(int[] args) {
                return AppFileLocProvider.this.queryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return AppFileLocProvider.this.AddRef();
            }

            public int method2(int[] args) {
                return AppFileLocProvider.this.Release();
            }
        };
        this.directoryServiceProvider = new XPCOMObject(new int[]{2, 0, 0, 3}){

            public int method0(int[] args) {
                return AppFileLocProvider.this.queryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return AppFileLocProvider.this.AddRef();
            }

            public int method2(int[] args) {
                return AppFileLocProvider.this.Release();
            }

            public int method3(int[] args) {
                return AppFileLocProvider.this.getFile(args[0], args[1], args[2]);
            }
        };
        this.directoryServiceProvider2 = new XPCOMObject(new int[]{2, 0, 0, 3, 2}){

            public int method0(int[] args) {
                return AppFileLocProvider.this.queryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return AppFileLocProvider.this.AddRef();
            }

            public int method2(int[] args) {
                return AppFileLocProvider.this.Release();
            }

            public int method3(int[] args) {
                return AppFileLocProvider.this.getFile(args[0], args[1], args[2]);
            }

            public int method4(int[] args) {
                return AppFileLocProvider.this.getFiles(args[0], args[1]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.directoryServiceProvider != null) {
            this.directoryServiceProvider.dispose();
            this.directoryServiceProvider = null;
        }
        if (this.directoryServiceProvider2 != null) {
            this.directoryServiceProvider2.dispose();
            this.directoryServiceProvider2 = null;
        }
    }

    int getAddress() {
        return this.directoryServiceProvider.getAddress();
    }

    int queryInterface(int riid, int ppvObject) {
        if (riid == 0 || ppvObject == 0) {
            return -2147467262;
        }
        nsID guid = new nsID();
        XPCOM.memmove((nsID)guid, (int)riid, (int)16);
        if (guid.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove((int)ppvObject, (int[])new int[]{this.supports.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIDirectoryServiceProvider.NS_IDIRECTORYSERVICEPROVIDER_IID)) {
            XPCOM.memmove((int)ppvObject, (int[])new int[]{this.directoryServiceProvider.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIDirectoryServiceProvider2.NS_IDIRECTORYSERVICEPROVIDER2_IID)) {
            XPCOM.memmove((int)ppvObject, (int[])new int[]{this.directoryServiceProvider2.getAddress()}, (int)4);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove((int)ppvObject, (int[])new int[]{0}, (int)4);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int getFiles(int str, int nsISimpleEnumerator) {
        int rc = -2147467259;
        int length = XPCOM.strlen((int)str);
        byte[] dest = new byte[length];
        XPCOM.memmove((byte[])dest, (int)str, (int)length);
        String prop = new String(dest);
        XPCOM.memmove((int)nsISimpleEnumerator, (int[])new int[]{0}, (int)4);
        nsILocalFile localFile = null;
        if ("APluginsDL".equals(prop)) {
            if (this.mozillaPath == null) {
                return -2147467259;
            }
            if (this.mozillaPath.length() <= 0) {
                return -2147467259;
            }
            int[] result = new int[1];
            nsString path = new nsString(this.mozillaPath);
            rc = XPCOM.NS_NewLocalFile((int)path.getAddress(), (boolean)true, (int[])result);
            path.dispose();
            if (rc == 0 && result[0] == 0) {
                rc = -2147467261;
            }
            if (rc == 0) {
                localFile = new nsILocalFile(result[0]);
            }
            nsString node = new nsString("plugins");
            rc = localFile.Append(node.getAddress());
            node.dispose();
        }
        if (rc == 0) {
            int[] retVal = new int[1];
            rc = XPCOM.NS_NewSingletonEnumerator((int)localFile.getAddress(), (int[])retVal);
            if (rc == 0 && retVal[0] == 0) {
                rc = -2147467261;
            }
            if (rc == 0) {
                XPCOM.memmove((int)nsISimpleEnumerator, (int[])retVal, (int)4);
            }
        }
        if (localFile != null) {
            localFile.Release();
        }
        return rc;
    }

    int getFile(int str, int persistent, int nsFile) {
        nsString path;
        int[] result;
        int rc = -2147467259;
        int length = XPCOM.strlen((int)str);
        byte[] dest = new byte[length];
        XPCOM.memmove((byte[])dest, (int)str, (int)length);
        String prop = new String(dest);
        XPCOM.memmove((int)persistent, (int[])new int[]{1}, (int)4);
        XPCOM.memmove((int)nsFile, (int[])new int[]{0}, (int)4);
        nsILocalFile localFile = null;
        if ("GreD".equals(prop) || "GreComsD".equals(prop)) {
            if (this.grePath == null || this.grePath.length() == 0) {
                return -2147467259;
            }
            result = new int[1];
            path = new nsString(this.grePath);
            rc = XPCOM.NS_NewLocalFile((int)path.getAddress(), (boolean)true, (int[])result);
            path.dispose();
            if (rc == 0 && result[0] == 0) {
                rc = -2147467261;
            }
            if (rc == 0) {
                localFile = new nsILocalFile(result[0]);
                if ("GreComsD".equals(prop)) {
                    nsString node = new nsString("components");
                    rc = localFile.Append(node.getAddress());
                    node.dispose();
                }
            }
        } else if ("MozBinD".equals(prop) || "CurProcD".equals(prop) || "ComsD".equals(prop) || "ProfD".equals(prop)) {
            if (this.mozillaPath == null || this.mozillaPath.length() == 0) {
                return -2147467259;
            }
            result = new int[1];
            path = new nsString(this.mozillaPath);
            rc = XPCOM.NS_NewLocalFile((int)path.getAddress(), (boolean)true, (int[])result);
            path.dispose();
            if (rc == 0 && result[0] == 0) {
                rc = -2147467261;
            }
            if (rc == 0) {
                localFile = new nsILocalFile(result[0]);
                if ("ComsD".equals(prop)) {
                    nsString node = new nsString("components");
                    rc = localFile.Append(node.getAddress());
                    node.dispose();
                }
            }
        }
        if (localFile != null && 0 == rc) {
            result = new int[1];
            int rc1 = localFile.QueryInterface(nsIFile.NS_IFILE_IID, result);
            if (rc1 != 0 || result[0] == 0) {
                rc1 = -2147467262;
            } else {
                XPCOM.memmove((int)nsFile, (int[])result, (int)4);
            }
        }
        if (localFile != null) {
            localFile.Release();
        }
        return rc;
    }
}

