/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.IOException;
import java.io.Reader;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;

public final class WordTokenStream
extends TokenStream {
    private static final int BUF_LEN = 4096;
    private static final int TOKENS_LEN = 512;
    private final String fieldName;
    private final Reader reader;
    private final BreakIterator boundary;
    private final ArrayList tokens;
    private int token;
    private int noTokens;
    private final char[] cbuf;

    public WordTokenStream(String fieldName, Reader reader, Locale locale) {
        this.fieldName = fieldName;
        this.reader = reader;
        this.boundary = BreakIterator.getWordInstance(locale);
        this.cbuf = new char[4096];
        this.tokens = new ArrayList(512);
    }

    public final Token next() throws IOException {
        while (this.token >= this.noTokens) {
            int c;
            int l;
            while ((l = this.reader.read(this.cbuf)) <= 0) {
                if (l >= 0) continue;
                this.reader.close();
                return null;
            }
            StringBuffer strbuf = new StringBuffer(l + 80);
            strbuf.append(this.cbuf, 0, l);
            while (0 <= (c = this.reader.read())) {
                strbuf.append((char)c);
                if (c != 32 && c != 13 && c != 10 && c != 9) continue;
            }
            String str = strbuf.toString();
            this.boundary.setText(str);
            int start = this.boundary.first();
            this.tokens.clear();
            int end = this.boundary.next();
            while (end != -1) {
                for (int i = start; i < end; ++i) {
                    if (!Character.isLetterOrDigit(str.charAt(i))) continue;
                    this.tokens.add(new Token(str.substring(start, end), start, end));
                    break;
                }
                start = end;
                end = this.boundary.next();
            }
            if (c < 0) {
                this.reader.close();
                this.tokens.add(null);
            }
            this.noTokens = this.tokens.size();
            this.token = 0;
        }
        return (Token)this.tokens.get(this.token++);
    }
}

