//
//  CLBoundView.h
//  DateLine
//
//  Created by Alex Clarke on 6/05/05.
//  Copyright 2005 CocoaLab. All rights reserved.
//
// Code courtesy of Apple Computer Inc

#import <Cocoa/Cocoa.h>

@class CLMonthLine;

@interface CLBoundView : NSView 
{
	IBOutlet NSArrayController * graphicsController;
	NSObject *graphicsContainer;
	NSString *graphicsKeyPath;
	NSObject *selectionIndexesContainer;
	NSString *selectionIndexesKeyPath;
	NSArray *oldGraphics;
	
	NSAffineTransform *transform;
}

+ (Class)class;

- (NSArray *)graphics;
- (NSIndexSet *)selectionIndexes;

- (NSAffineTransform *)transform;
- (void) setTransform:(NSAffineTransform *)aTransform;

- (void) setElementColor:(NSColor *)elementColor;
- (void) setTextColor:(NSColor *)textColor;
- (void) setTodayTextColor:(NSColor *)aColor;
- (void) setTodayMarkColor:(NSColor *)aColor;
- (void) setDayMarkColor:(NSColor *)aColor;

- (void)startObservingGraphics:(NSArray *)graphics;
- (void)stopObservingGraphics:(NSArray *)graphics;

- (NSArray *)oldGraphics;
- (void)setOldGraphics:(NSArray *)anOldGraphics;

- (NSObject *)graphicsContainer;
- (void)setGraphicsContainer:(NSObject *)aGraphicsContainer;
- (NSObject *)selectionIndexesContainer;
- (void)setSelectionIndexesContainer:(NSObject *)aSelectionIndexesContainer;

- (NSString *)graphicsKeyPath;
- (void)setGraphicsKeyPath:(NSString *)aGraphicsKeyPath;
- (NSString *)selectionIndexesKeyPath;
- (void)setSelectionIndexesKeyPath:(NSString *)aSelectionIndexesKeyPath;

- (void)bind:(NSString *)bindingName toObject:(id)observableObject withKeyPath:(NSString *)observableKeyPath options:(NSDictionary *)options;


@end
