/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public class WhiteSpaceBeforeParagraphEnd
extends TextLevelRule {
    public WhiteSpaceBeforeParagraphEnd(ResourceBundle messages, boolean defaultActive) {
        super(messages);
        super.setCategory(Categories.STYLE.getCategory(messages));
        if (!defaultActive) {
            this.setDefaultOff();
        }
        this.setOfficeDefaultOn();
        this.setLocQualityIssueType(ITSIssueType.Style);
    }

    public WhiteSpaceBeforeParagraphEnd(ResourceBundle messages) {
        this(messages, false);
    }

    @Override
    public String getId() {
        return "WHITESPACE_PARAGRAPH";
    }

    @Override
    public String getDescription() {
        return this.messages.getString("whitespace_before_parapgraph_end_desc");
    }

    private static boolean isWhitespaceDel(AnalyzedTokenReadings token) {
        return token.isWhitespace() && !token.getToken().equals("\u200b") && !token.isLinebreak();
    }

    private static boolean isParaBreak(AnalyzedTokenReadings token) {
        return "\n".equals(token.getToken()) || "\r\n".equals(token.getToken()) || "\n\r".equals(token.getToken());
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int pos = 0;
        for (int n = 0; n < sentences.size(); ++n) {
            int i;
            AnalyzedSentence sentence = sentences.get(n);
            AnalyzedTokenReadings[] tokens = sentence.getTokens();
            for (i = 1; i < tokens.length; ++i) {
                if (!WhiteSpaceBeforeParagraphEnd.isParaBreak(tokens[i])) continue;
                int lastPara = i--;
                while (i > 0 && WhiteSpaceBeforeParagraphEnd.isWhitespaceDel(tokens[i])) {
                    --i;
                }
                if (lastPara > i + 1) {
                    int fromPos = i > 0 && !tokens[i].isWhitespace() ? pos + tokens[i].getStartPos() : pos + tokens[i + 1].getStartPos();
                    int toPos = pos + tokens[lastPara - 1].getEndPos();
                    RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, fromPos, toPos, this.messages.getString("whitespace_before_parapgraph_end_msg"));
                    if (i > 0 && !tokens[i].isWhitespace()) {
                        ruleMatch.setSuggestedReplacement(tokens[i].getToken());
                    }
                    ruleMatches.add(ruleMatch);
                }
                i = lastPara;
            }
            if (n == sentences.size() - 1) {
                for (i = tokens.length - 1; i > 0 && WhiteSpaceBeforeParagraphEnd.isWhitespaceDel(tokens[i]); --i) {
                }
                if (i < tokens.length - 1) {
                    int fromPos = pos + tokens[i + 1].getStartPos();
                    int toPos = pos + tokens[tokens.length - 1].getStartPos() + 1;
                    RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, fromPos, toPos, this.messages.getString("whitespace_before_parapgraph_end_msg"));
                    ruleMatch.setSuggestedReplacement("");
                    ruleMatches.add(ruleMatch);
                }
            }
            pos += sentence.getText().length();
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

