/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.neuralnetwork;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.rules.neuralnetwork.Matrix;

public class MatrixTest {
    @Test
    public void matrixFromListTest() {
        String matrixString = "1 2\n3 4\n5 6";
        Matrix expectedMatrix = new Matrix((float[][])new float[][]{{1.0f, 2.0f}, {3.0f, 4.0f}, {5.0f, 6.0f}});
        Matrix matrix = new Matrix(Arrays.asList(matrixString.split("\n")));
        Assert.assertEquals((Object)expectedMatrix, (Object)matrix);
    }

    @Test
    public void matMulTest() {
        Matrix a = new Matrix((float[][])new float[][]{{1.0f, 2.0f}, {3.0f, 4.0f}, {5.0f, 6.0f}});
        Matrix b = new Matrix((float[][])new float[][]{{1.0f}, {2.0f}});
        Matrix c = new Matrix((float[][])new float[][]{{5.0f}, {11.0f}, {17.0f}});
        Assert.assertEquals((Object)c, (Object)a.mul(b));
    }

    @Test
    public void matAddTest() {
        Matrix a = new Matrix((float[][])new float[][]{{1.0f, 2.0f}, {3.0f, 4.0f}, {5.0f, 6.0f}});
        Matrix b = new Matrix((float[][])new float[][]{{1.0f, 2.0f}, {3.0f, 4.0f}, {5.0f, 7.0f}});
        Matrix c = new Matrix((float[][])new float[][]{{2.0f, 4.0f}, {6.0f, 8.0f}, {10.0f, 13.0f}});
        Assert.assertEquals((Object)c, (Object)a.add(b));
    }

    @Test
    public void matReluTest() {
        Matrix a = new Matrix((float[][])new float[][]{{1.0f, 2.0f}, {-3.0f, 0.0f}});
        Matrix b = new Matrix((float[][])new float[][]{{1.0f, 2.0f}, {0.0f, 0.0f}});
        Assert.assertEquals((Object)b, (Object)a.relu());
    }
}

