/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.io.IOException;

public final class BasicAuthentication
implements HttpRequestInitializer,
HttpExecuteInterceptor {
    private final String username;
    private final String password;

    public BasicAuthentication(String username, String password) {
        this.username = Preconditions.checkNotNull(username);
        this.password = Preconditions.checkNotNull(password);
    }

    @Override
    public void initialize(HttpRequest request) throws IOException {
        request.setInterceptor(this);
        this.intercept(request);
    }

    @Override
    public void intercept(HttpRequest request) throws IOException {
        request.getHeaders().setBasicAuthentication(this.username, this.password);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

