/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool;

import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.cloud.sql.tool.Command;
import com.google.cloud.sql.tool.Commands;
import com.google.cloud.sql.tool.TeeWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;

public class Context {
    private static final PrintWriter NULL_WRITER = new PrintWriter(new TeeWriter.NullWriter());
    private final TeeWriter tee;
    private final PrintWriter out;
    private final Commands commands;
    private PrintWriter file;
    private String fileName;
    private boolean shutdown;
    private List<String> statement = Lists.newArrayList();
    private boolean showWarningsEnabled;
    private String delimiter = ";";

    public Context(Commands commands) {
        this.commands = commands;
        this.tee = new TeeWriter(System.out, Charset.defaultCharset());
        this.out = new PrintWriter(this.tee);
        this.file = NULL_WRITER;
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public void setDisplayWriter(Writer display) {
        this.tee.setDisplayWriter(display);
    }

    public void setFileOutputName(String fileName) throws IOException {
        this.file.close();
        if (fileName == null) {
            this.setNullFileWriter();
        }
        try {
            PrintWriter file = new PrintWriter(new FileWriter(fileName, true));
            this.tee.setFileOutputWriter(file);
            this.file = file;
            this.fileName = fileName;
        }
        catch (IOException e) {
            this.setNullFileWriter();
            throw e;
        }
    }

    public void setNullFileWriter() {
        this.file.close();
        this.file = NULL_WRITER;
        this.fileName = null;
    }

    public String getFileOutputName() {
        return this.fileName;
    }

    public boolean isFileOutputEnabled() {
        return this.file == NULL_WRITER;
    }

    public PrintWriter getFileWriter() {
        return this.file;
    }

    public String getCurrentStatementSql() {
        return Joiner.on('\n').join(this.statement);
    }

    public void addStatementLine(String line) {
        this.statement.add(line);
    }

    public void clearCurrentStatement() {
        this.statement.clear();
    }

    public boolean hasCurrentStatement() {
        return !this.statement.isEmpty();
    }

    public Collection<Command> getCommands() {
        return this.commands.getCommands();
    }

    public boolean isShowWarningsEnabled() {
        return this.showWarningsEnabled;
    }

    public void setShowWarningsEnabled(boolean showWarningsEnabled) {
        this.showWarningsEnabled = showWarningsEnabled;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

