/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;

class TeeWriter
extends FilterWriter {
    private Writer display;
    private Writer file;

    public TeeWriter(OutputStream out, Charset cs) {
        this(new OutputStreamWriter(out, cs), new NullWriter());
    }

    private TeeWriter(Writer display, Writer file) {
        super(display);
        this.display = display;
        this.file = file;
    }

    void setDisplayWriter(Writer display) {
        this.display = display != null ? display : new NullWriter();
    }

    void setFileOutputWriter(Writer file) {
        this.file = file != null ? file : new NullWriter();
    }

    @Override
    public void write(int b) throws IOException {
        this.display.write(b);
        this.file.write(b);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.display.write(cbuf, off, len);
        this.file.write(cbuf, off, len);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.display.write(str, off, len);
        this.file.write(str, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.display.flush();
        this.file.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.file.close();
    }

    static final class NullWriter
    extends OutputStreamWriter {
        NullWriter() {
            super(new NullOutputStream());
        }

        static final class NullOutputStream
        extends OutputStream {
            NullOutputStream() {
            }

            @Override
            public void write(int b) {
            }

            @Override
            public void write(byte[] b, int off, int len) {
            }
        }
    }
}

