/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool.commands;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.collect.Collections2;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.cloud.sql.tool.AbstractCommand;
import com.google.cloud.sql.tool.Command;
import com.google.cloud.sql.tool.CommandException;
import com.google.cloud.sql.tool.CommandName;
import com.google.cloud.sql.tool.Context;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HelpCommand
extends AbstractCommand {
    private int maxCommandWidth = 0;
    private static final Function<Command, Integer> MAX_NAME_SIZE = new Function<Command, Integer>(){

        @Override
        public Integer apply(Command from) {
            return (Integer)Collections.max(Collections2.transform(from.getNames(), NAME_SIZE));
        }
    };
    private static final Function<CommandName, Integer> NAME_SIZE = new Function<CommandName, Integer>(){

        @Override
        public Integer apply(CommandName name) {
            return name.getName().length();
        }
    };

    public HelpCommand() {
        super(ImmutableList.of(new CommandName("help", 'h'), new CommandName("?", '?')), "Displays help.");
    }

    @Override
    public Command.Result execute(List<String> args, Context context) throws CommandException {
        ArrayList<String> commandText = Lists.newArrayListWithExpectedSize(context.getCommands().size());
        int max = this.getMaxCommandWidth(context);
        for (Command c : context.getCommands()) {
            for (CommandName commandName : c.getNames()) {
                StringBuilder sb = new StringBuilder(100);
                String name = commandName.getName();
                sb.append(name);
                for (int pad = name.length(); pad <= max; ++pad) {
                    sb.append(' ');
                }
                sb.append(' ');
                sb.append(commandName.getShortName());
                sb.append(' ');
                sb.append(c.getHelpText());
                commandText.add(sb.toString());
            }
        }
        Collections.sort(commandText);
        try {
            PrintWriter out = context.getWriter();
            Joiner.on('\n').appendTo(out, commandText);
            out.println();
            out.flush();
        }
        catch (IOException e) {
            throw new CommandException(this, "Error displaying help text.", e);
        }
        return Command.Result.OK;
    }

    private int getMaxCommandWidth(Context context) {
        if (this.maxCommandWidth == 0) {
            this.maxCommandWidth = Collections.max(Collections2.transform(context.getCommands(), MAX_NAME_SIZE));
        }
        return this.maxCommandWidth;
    }
}

