/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool.googleapi;

import com.google.api.client.auth.oauth2.draft10.AccessTokenErrorResponse;
import com.google.api.client.auth.oauth2.draft10.AccessTokenRequest;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.base.Supplier;
import com.google.appengine.repackaged.com.google.common.base.Suppliers;
import com.google.appengine.repackaged.com.google.common.flags.Flag;
import com.google.appengine.repackaged.com.google.common.flags.FlagSpec;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.cloud.sql.jdbc.internal.googleapi.OAuthTokens;
import com.google.cloud.sql.tool.connections.ConnectionException;
import com.google.cloud.sql.tool.connections.ConnectionFactory;
import com.google.cloud.sql.tool.connections.ConsoleSupplier;
import com.google.cloud.sql.tool.connections.FlagsConnectionFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.prefs.Preferences;

public class OAuth2ConnectionFactory
implements ConnectionFactory {
    @FlagSpec(help="Google username (i.e. sqlman@gmail.com) to use to authenticate to the SQL instance.", altName="oauth2_authorization_code")
    private static final Flag<String> oauth2AuthorizationCode = Flag.value("");
    @FlagSpec(help="Show full OAuth2 authorize URL.", altName="oauth2_full_auth_url")
    private static final Flag<Boolean> oauth2FullAuthUrl = Flag.value(false);
    private static final String[] AUTHORIZE_MESSAGE = new String[]{"Please authorize Google SQL Service for your Google Account at:"};
    private static final String SHORT_OAUTH2_AUTHORIZE_URL = "http://goo.gl/Ov319";
    private static final String PREFS_PACKAGE = "/com/google/cloud/sqlservice/oauth2";
    private final String authorizationCode;
    private final Preferences prefs;
    private final HttpTransport transport = new NetHttpTransport();
    private final JsonFactory jsonFactory = new JacksonFactory();

    public OAuth2ConnectionFactory() {
        this(Preferences.userRoot().node(PREFS_PACKAGE));
    }

    public OAuth2ConnectionFactory(Preferences prefs) {
        this.authorizationCode = oauth2AuthorizationCode.get();
        this.prefs = prefs;
    }

    protected Supplier<String> getAuthorizationCode(Url url) {
        if (Strings.isNullOrEmpty(this.authorizationCode)) {
            PrintWriter out = System.console() != null ? System.console().writer() : new PrintWriter(System.out);
            for (String line : OAuth2ConnectionFactory.createAuthorizationMessage(url)) {
                out.println(line);
            }
            return new ConsoleSupplier("Enter Authorization Code");
        }
        return Suppliers.ofInstance(this.authorizationCode);
    }

    @Override
    public Connection connect(String urlString, Map<String, String> props) throws ConnectionException, SQLException {
        Url url = Url.createFromMap(urlString, props);
        OAuthTokens tokens = this.getOAuth2Tokens(url);
        if (tokens == null) {
            tokens = this.createOAuth2TokenFlow(url);
            this.saveOAuth2Tokens(url, tokens);
        }
        return new FlagsConnectionFactory().connect(urlString, props);
    }

    private OAuthTokens createOAuth2TokenFlow(Url url) throws ConnectionException {
        String code = this.getAuthorizationCode(url).get();
        if (Strings.isNullOrEmpty(code)) {
            throw new ConnectionException("No access code entered.");
        }
        OAuthTokens tokens = OAuthTokens.fromUrl(url);
        AccessTokenRequest.AuthorizationCodeGrant request = new AccessTokenRequest.AuthorizationCodeGrant();
        request.transport = this.transport;
        request.jsonFactory = this.jsonFactory;
        request.authorizationServerUrl = url.getOAuth2TokenUrl();
        request.clientId = tokens.getOAuth2ClientId();
        request.clientSecret = tokens.getOAuth2ClientSecret();
        request.code = code;
        request.redirectUri = "oob";
        request.useBasicAuthorization = false;
        try {
            return tokens.withResponse(request.execute());
        }
        catch (HttpResponseException e) {
            try {
                AccessTokenErrorResponse response = e.getResponse().parseAs(AccessTokenErrorResponse.class);
                throw new ConnectionException(String.format("Unable to fetch OAuth2 tokens: %s: %s.", response.getErrorCodeIfKnown().name(), response.errorDescription), e);
            }
            catch (IOException ioe) {
                throw new ConnectionException("Unable to fetch OAuth2 tokens.", e);
            }
            catch (IllegalArgumentException iae) {
                throw new ConnectionException("Unable to fetch OAuth2 tokens.", e);
            }
        }
        catch (IOException e) {
            throw new ConnectionException("Unable to fetch OAuth2 tokens.", e);
        }
    }

    private OAuthTokens getOAuth2Tokens(Url url) {
        if (url.getOAuth2RefreshToken() != null || url.getOAuth2AccessToken() != null) {
            return OAuthTokens.fromUrl(url);
        }
        String refreshToken = this.prefs.get(url.getOAuth2TokenUrl(), null);
        if (refreshToken == null) {
            return null;
        }
        return OAuthTokens.fromUrl(url).withRefreshToken(refreshToken);
    }

    private void saveOAuth2Tokens(Url url, OAuthTokens tokens) {
        this.prefs.put(url.getOAuth2TokenUrl(), tokens.getRefreshToken());
    }

    private static String createAuthorizeUrl(Url url) {
        if (!oauth2FullAuthUrl.get().booleanValue()) {
            return SHORT_OAUTH2_AUTHORIZE_URL;
        }
        return String.format("%s?response_type=code&scope=%s&redirect_uri=%s&client_id=%s", url.getOAuth2AuthUrl(), "https://www.googleapis.com/auth/sqlservice", "oob", OAuthTokens.getOAuth2ClientId(url));
    }

    private static Iterable<String> createAuthorizationMessage(Url url) {
        ArrayList<String> message = Util.newArrayList(AUTHORIZE_MESSAGE);
        message.add(OAuth2ConnectionFactory.createAuthorizeUrl(url));
        return message;
    }
}

