/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool.printers;

import com.google.cloud.sql.tool.SqlProcessor;
import com.google.cloud.sql.tool.printers.Printer;
import com.google.cloud.sql.tool.printers.TabularPipedPrinter;
import com.google.cloud.sql.tool.printers.TabularTerminalPrinter;
import com.google.cloud.sql.tool.printers.VerticalPrinter;
import java.io.PrintWriter;
import java.sql.ResultSetMetaData;

public class PrinterFactory {
    private final SqlProcessor.PrintMode executionMode;
    private final boolean hasTerminal;
    private final PrintWriter out;

    public PrinterFactory(SqlProcessor.PrintMode executionMode, boolean hasTerminal, PrintWriter out) {
        this.executionMode = executionMode;
        this.hasTerminal = hasTerminal;
        this.out = out;
    }

    public Printer createPrinter(ResultSetMetaData md, float elapsedSeconds) {
        if (this.hasTerminal) {
            return this.executionMode == SqlProcessor.PrintMode.TABULAR ? new TabularTerminalPrinter(md, elapsedSeconds, this.out) : new VerticalPrinter(md, elapsedSeconds, this.out);
        }
        return this.executionMode == SqlProcessor.PrintMode.TABULAR ? new TabularPipedPrinter(md, elapsedSeconds, this.out) : new VerticalPrinter(md, elapsedSeconds, this.out);
    }
}

