/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.GeoPt;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.users.User;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class RawValue
implements Serializable {
    private transient OnestoreEntity.PropertyValue propertyValue;

    RawValue(OnestoreEntity.PropertyValue propertyValue) {
        this.propertyValue = Preconditions.checkNotNull(propertyValue);
    }

    public <T> T asStrictType(Class<T> type) {
        Object value = this.asType(type);
        if (value != null) {
            Preconditions.checkArgument(type.isAssignableFrom(value.getClass()), "Unsupported type: " + type);
        }
        return (T)value;
    }

    public Object asType(Class<?> type) {
        DataTypeTranslator.Type<?> typeAdapter = DataTypeTranslator.getTypeMap().get(type);
        Preconditions.checkArgument(typeAdapter != null, "Unsupported type: " + type);
        if (!typeAdapter.hasPropertyValue(this.propertyValue)) {
            Preconditions.checkArgument(this.propertyValue.equals(OnestoreEntity.PropertyValue.IMMUTABLE_DEFAULT_INSTANCE), "Type mismatch.");
            return null;
        }
        return typeAdapter.getPropertyValue(this.propertyValue);
    }

    public Object getValue() {
        if (this.propertyValue.hasBooleanValue()) {
            return this.propertyValue.isBooleanValue();
        }
        if (this.propertyValue.hasDoubleValue()) {
            return this.propertyValue.getDoubleValue();
        }
        if (this.propertyValue.hasInt64Value()) {
            return this.propertyValue.getInt64Value();
        }
        if (this.propertyValue.hasPointValue()) {
            return this.asType(GeoPt.class);
        }
        if (this.propertyValue.hasReferenceValue()) {
            return this.asType(Key.class);
        }
        if (this.propertyValue.hasStringValue()) {
            return this.propertyValue.getStringValueAsBytes();
        }
        if (this.propertyValue.hasUserValue()) {
            return this.asType(User.class);
        }
        return null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.write(1);
        this.propertyValue.writeTo(out);
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Preconditions.checkArgument(in.read() == 1);
        this.propertyValue = new OnestoreEntity.PropertyValue();
        this.propertyValue.parseFrom(in);
        in.defaultReadObject();
    }

    public int hashCode() {
        return this.propertyValue.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RawValue other = (RawValue)obj;
        return this.propertyValue.equals(other.propertyValue);
    }

    public String toString() {
        return "RawValue [value=" + this.getValue() + "]";
    }
}

