/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class ByteArrayDataSource
implements DataSource {
    private byte[] source;
    private String contentType;
    private String name = "";

    public ByteArrayDataSource(InputStream in, String type) throws IOException {
        int bytesRead;
        ByteArrayOutputStream sink = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((bytesRead = in.read(buffer)) > 0) {
            sink.write(buffer, 0, bytesRead);
        }
        this.source = sink.toByteArray();
        this.contentType = type;
    }

    public ByteArrayDataSource(byte[] data, String type) {
        this.source = data;
        this.contentType = type;
    }

    public ByteArrayDataSource(String data, String type) throws IOException {
        String charset = null;
        try {
            ContentType content = new ContentType(type);
            charset = content.getParameter("charset");
        }
        catch (ParseException e) {
            // empty catch block
        }
        charset = charset == null ? MimeUtility.getDefaultJavaCharset() : MimeUtility.javaCharset(charset);
        this.source = data.getBytes(charset);
        this.contentType = type;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.source);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("Writing to a ByteArrayDataSource is not supported");
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

