/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.api.taskqueue.dev.LocalTaskQueueCallback;
import com.google.appengine.api.urlfetch.URLFetchServicePb;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.testing.LocalServiceTestHelper;
import com.google.apphosting.api.ApiProxy;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

class EnvSettingTaskqueueCallback
implements LocalTaskQueueCallback {
    private static final String DELEGATE_CLASS_PROP = EnvSettingTaskqueueCallback.class.getName() + ".delegateClass";
    private static final String COPY_ENVIRONMENT_PROP = EnvSettingTaskqueueCallback.class.getName() + ".copyEnvironment";
    private static final String TASK_EXECUTION_LATCH_PROP = EnvSettingTaskqueueCallback.class.getName() + ".taskExecutionLatch";
    private LocalTaskQueueCallback delegate;
    private boolean shouldCopyEnvironment;
    private ApiProxy.Environment environmentFromInitializingThread;
    private CountDownLatch taskExecutionLatch;

    EnvSettingTaskqueueCallback() {
    }

    static void setProxyProperties(ApiProxyLocal proxy, Class<? extends LocalTaskQueueCallback> delegateClass, boolean shouldCopyApiProxyEnvironment) {
        proxy.setProperty(DELEGATE_CLASS_PROP, delegateClass.getName());
        proxy.setProperty(COPY_ENVIRONMENT_PROP, Boolean.toString(shouldCopyApiProxyEnvironment));
    }

    static void setTaskExecutionLatch(CountDownLatch latch) {
        ApiProxy.getCurrentEnvironment().getAttributes().put(TASK_EXECUTION_LATCH_PROP, latch);
    }

    public void initialize(Map<String, String> properties) {
        String delegateClassName = properties.get(DELEGATE_CLASS_PROP);
        try {
            this.delegate = (LocalTaskQueueCallback)Class.forName(delegateClassName).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.shouldCopyEnvironment = Boolean.parseBoolean(properties.get(COPY_ENVIRONMENT_PROP));
        if (this.shouldCopyEnvironment) {
            this.environmentFromInitializingThread = ApiProxy.getCurrentEnvironment();
            if (null == this.environmentFromInitializingThread) {
                throw new RuntimeException(Thread.currentThread().getName());
            }
        }
        this.taskExecutionLatch = (CountDownLatch)ApiProxy.getCurrentEnvironment().getAttributes().get(TASK_EXECUTION_LATCH_PROP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(URLFetchServicePb.URLFetchRequest req) {
        ApiProxy.setEnvironmentForCurrentThread(this.buildNewEnvironment());
        try {
            int n = this.delegate.execute(req);
            return n;
        }
        finally {
            if (this.taskExecutionLatch != null) {
                this.taskExecutionLatch.countDown();
            }
        }
    }

    private ApiProxy.Environment buildNewEnvironment() {
        if (this.shouldCopyEnvironment) {
            return LocalServiceTestHelper.copyEnvironment(this.environmentFromInitializingThread);
        }
        return LocalServiceTestHelper.newDefaultTestEnvironment();
    }
}

