/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.api.memcache.MemcacheServicePb;
import com.google.appengine.api.memcache.dev.LocalMemcacheService;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestHelper;

public class LocalMemcacheServiceTestConfig
implements LocalServiceTestConfig {
    private Long maxSize;
    private SizeUnit maxSizeUnits = SizeUnit.BYTES;

    @Override
    public void setUp() {
        ApiProxyLocal proxy = LocalServiceTestHelper.getApiProxyLocal();
        if (this.maxSize != null) {
            proxy.setProperty("memcache.maxsize", String.format("%d%s", this.maxSize, this.maxSizeUnits.abbreviation));
        }
    }

    @Override
    public void tearDown() {
        MemcacheServicePb.MemcacheFlushRequest request = MemcacheServicePb.MemcacheFlushRequest.newBuilder().build();
        LocalRpcService.Status status = new LocalRpcService.Status();
        LocalMemcacheServiceTestConfig.getLocalMemcacheService().flushAll(status, request);
    }

    public Long getMaxSize() {
        return this.maxSize;
    }

    public SizeUnit getMaxSizeUnits() {
        return this.maxSizeUnits;
    }

    public LocalMemcacheServiceTestConfig setMaxSize(long maxSize, SizeUnit maxSizeUnits) {
        this.maxSize = maxSize;
        this.maxSizeUnits = maxSizeUnits;
        return this;
    }

    public static LocalMemcacheService getLocalMemcacheService() {
        return (LocalMemcacheService)LocalServiceTestHelper.getLocalService("memcache");
    }

    public static enum SizeUnit {
        BYTES(""),
        KB("K"),
        MB("M");

        private final String abbreviation;

        private SizeUnit(String abbreviation) {
            this.abbreviation = abbreviation;
        }
    }
}

